/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.common.time;

import io.skylite.common.unit.TimeValue;
import io.skylite.core.ParseField;
import io.skylite.core.common.time.DateUtils;
import java.time.Instant;
import org.apache.lucene.document.LongPoint;

public enum DateResolution {
    MILLISECONDS(ParseField.CoreTypes.DATE_FIELD.getPreferredName()){

        @Override
        public long convert(Instant instant) {
            return instant.toEpochMilli();
        }

        @Override
        public long convert(TimeValue timeValue) {
            return timeValue.getMillis();
        }

        @Override
        public Instant toInstant(long value) {
            return Instant.ofEpochMilli(value);
        }

        @Override
        public Instant clampToValidRange(Instant instant) {
            return instant;
        }

        @Override
        public long parsePointAsMillis(byte[] value) {
            return LongPoint.decodeDimension((byte[])value, (int)0);
        }
    }
    ,
    NANOSECONDS(ParseField.CommonFields.DATE_NANOS.getPreferredName()){

        @Override
        public long convert(Instant instant) {
            return DateUtils.toLong(instant);
        }

        @Override
        public long convert(TimeValue timeValue) {
            return timeValue.getNanos();
        }

        @Override
        public Instant toInstant(long value) {
            return DateUtils.toInstant(value);
        }

        @Override
        public Instant clampToValidRange(Instant instant) {
            return DateUtils.clampToNanosRange(instant);
        }

        @Override
        public long parsePointAsMillis(byte[] value) {
            return DateUtils.toMilliSeconds(LongPoint.decodeDimension((byte[])value, (int)0));
        }
    };

    private final String type;

    private DateResolution(String type) {
        this.type = type;
    }

    public String type() {
        return this.type;
    }

    public abstract long convert(Instant var1);

    public abstract long convert(TimeValue var1);

    public abstract Instant toInstant(long var1);

    public abstract Instant clampToValidRange(Instant var1);

    public abstract long parsePointAsMillis(byte[] var1);

    public static DateResolution ofOrdinal(int ord) {
        for (DateResolution resolution : DateResolution.values()) {
            if (ord != resolution.ordinal()) continue;
            return resolution;
        }
        throw new IllegalArgumentException("unknown resolution ordinal [" + ord + "]");
    }
}

