/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.common.util;

import io.skylite.core.common.util.BigArray;
import io.skylite.core.common.util.BigArrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.util.Accountable;

abstract class AbstractArray
implements BigArray {
    private final BigArrays bigArrays;
    public final boolean clearOnResize;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    AbstractArray(BigArrays bigArrays, boolean clearOnResize) {
        this.bigArrays = bigArrays;
        this.clearOnResize = clearOnResize;
    }

    public final void close() {
        if (this.closed.compareAndSet(false, true)) {
            try {
                this.bigArrays.adjustBreaker(-this.ramBytesUsed(), true);
            }
            finally {
                this.doClose();
            }
        }
    }

    protected abstract void doClose();

    public Collection<Accountable> getChildResources() {
        return Collections.emptyList();
    }
}

