/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.compress;

import io.skylite.common.Nullable;
import io.skylite.common.annotation.InternalApi;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.compress.Compressor;
import io.skylite.core.compress.NotCompressedException;
import io.skylite.core.compress.NotXContentException;
import io.skylite.core.compress.spi.CompressorProvider;
import io.skylite.core.xcontent.MediaTypeRegistry;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.stream.Collectors;

@InternalApi
public final class CompressorRegistry {
    private static final Map<String, Compressor> registeredCompressors = ServiceLoader.load(CompressorProvider.class, CompressorProvider.class.getClassLoader()).stream().flatMap(p -> ((CompressorProvider)p.get()).getCompressors().stream()).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));

    private CompressorRegistry() {
    }

    public static Compressor defaultCompressor() {
        return registeredCompressors.get("DEFLATE");
    }

    public static Compressor none() {
        return registeredCompressors.get("NONE");
    }

    public static boolean isCompressed(BytesReference bytes) {
        return CompressorRegistry.compressor(bytes) != null;
    }

    @Nullable
    public static Compressor compressor(BytesReference bytes) {
        for (Compressor compressor : registeredCompressors.values()) {
            if (!compressor.isCompressed(bytes)) continue;
            assert (MediaTypeRegistry.xContentType(bytes) == null);
            return compressor;
        }
        if (MediaTypeRegistry.xContentType(bytes) == null) {
            throw new NotXContentException("Compressor detection can only be called on some xcontent bytes or compressed xcontent bytes");
        }
        return null;
    }

    public static BytesReference uncompress(BytesReference bytes) throws IOException {
        Compressor compressor = CompressorRegistry.compressor(bytes);
        if (compressor == null) {
            throw new NotCompressedException();
        }
        return compressor.uncompress(bytes);
    }

    public static BytesReference uncompressIfNeeded(BytesReference bytes) throws IOException {
        Compressor compressor = CompressorRegistry.compressor(Objects.requireNonNull(bytes, "the BytesReference must not be null"));
        return compressor == null ? bytes : compressor.uncompress(bytes);
    }

    public static Compressor getCompressor(String name) {
        if (registeredCompressors.containsKey(name)) {
            return registeredCompressors.get(name);
        }
        throw new IllegalArgumentException("No registered compressor found by name [" + name + "]");
    }

    public static Map<String, Compressor> registeredCompressors() {
        return registeredCompressors;
    }
}

