/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.discovery;

import io.skylite.OpenSearchVersion;
import io.skylite.core.cluster.state.ClusterStateStats;
import io.skylite.core.cluster.state.PendingClusterStateStats;
import io.skylite.core.cluster.state.PublishClusterStateStats;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;

public class DiscoveryStats
implements Writeable,
ToXContentFragment {
    private final PendingClusterStateStats queueStats;
    private final PublishClusterStateStats publishStats;
    private final ClusterStateStats clusterStateStats;

    public DiscoveryStats(PendingClusterStateStats queueStats, PublishClusterStateStats publishStats, ClusterStateStats clusterStateStats) {
        this.queueStats = queueStats;
        this.publishStats = publishStats;
        this.clusterStateStats = clusterStateStats;
    }

    public DiscoveryStats(StreamInput in) throws IOException {
        this.queueStats = in.readOptionalWriteable(PendingClusterStateStats::new);
        this.publishStats = in.readOptionalWriteable(PublishClusterStateStats::new);
        this.clusterStateStats = in.getVersion().onOrAfter(OpenSearchVersion.V_2_12_0) ? in.readOptionalWriteable(ClusterStateStats::new) : null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable(this.queueStats);
        out.writeOptionalWriteable(this.publishStats);
        if (out.getVersion().onOrAfter(OpenSearchVersion.V_2_12_0)) {
            out.writeOptionalWriteable(this.clusterStateStats);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("discovery");
        if (this.queueStats != null) {
            this.queueStats.toXContent(builder, params);
        }
        if (this.publishStats != null) {
            this.publishStats.toXContent(builder, params);
        }
        if (this.clusterStateStats != null) {
            this.clusterStateStats.toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }

    public PendingClusterStateStats getQueueStats() {
        return this.queueStats;
    }

    public PublishClusterStateStats getPublishStats() {
        return this.publishStats;
    }

    public ClusterStateStats getClusterStateStats() {
        return this.clusterStateStats;
    }

    static final class Fields {
        static final String DISCOVERY = "discovery";

        Fields() {
        }
    }
}

