/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.geo;

import io.skylite.SkyliteParseException;
import io.skylite.common.geometry.Circle;
import io.skylite.common.geometry.Line;
import io.skylite.common.geometry.Point;
import io.skylite.common.geometry.Polygon;
import io.skylite.common.geometry.Rectangle;
import io.skylite.common.geometry.ShapeType;
import io.skylite.core.geo.CartesianPoint;
import io.skylite.core.geo.GeoPoint;
import io.skylite.core.xcontent.XContentParser;
import io.skylite.core.xcontent.XContentSubParser;
import java.io.IOException;
import java.util.HashMap;
import org.apache.lucene.geo.XYCircle;
import org.apache.lucene.geo.XYLine;
import org.apache.lucene.geo.XYPoint;
import org.apache.lucene.geo.XYPolygon;
import org.apache.lucene.geo.XYRectangle;

public class ShapeUtils {
    private static final String ERR_MSG_INVALID_TOKEN = "token [{}] not allowed";
    private static final String ERR_MSG_INVALID_FIELDS = "field must be either [lon|lat], [type|coordinates], or [geohash]";
    public static final String GEOJSON_TYPE = "type";
    public static final String GEOJSON_COORDS = "coordinates";

    private ShapeUtils() {
    }

    public static XYPolygon toLuceneXYPolygon(Polygon polygon) {
        XYPolygon[] holes = new XYPolygon[polygon.getNumberOfHoles()];
        for (int i = 0; i < holes.length; ++i) {
            holes[i] = new XYPolygon(ShapeUtils.doubleArrayToFloatArray(polygon.getHole(i).getX()), ShapeUtils.doubleArrayToFloatArray(polygon.getHole(i).getY()), new XYPolygon[0]);
        }
        return new XYPolygon(ShapeUtils.doubleArrayToFloatArray(polygon.getPolygon().getX()), ShapeUtils.doubleArrayToFloatArray(polygon.getPolygon().getY()), holes);
    }

    public static XYPolygon toLuceneXYPolygon(Rectangle r) {
        return new XYPolygon(new float[]{(float)r.getMinX(), (float)r.getMaxX(), (float)r.getMaxX(), (float)r.getMinX(), (float)r.getMinX()}, new float[]{(float)r.getMinY(), (float)r.getMinY(), (float)r.getMaxY(), (float)r.getMaxY(), (float)r.getMinY()}, new XYPolygon[0]);
    }

    public static XYRectangle toLuceneXYRectangle(Rectangle r) {
        return new XYRectangle((float)r.getMinX(), (float)r.getMaxX(), (float)r.getMinY(), (float)r.getMaxY());
    }

    public static XYPoint toLuceneXYPoint(Point point) {
        return new XYPoint((float)point.getX(), (float)point.getY());
    }

    public static XYLine toLuceneXYLine(Line line) {
        return new XYLine(ShapeUtils.doubleArrayToFloatArray(line.getX()), ShapeUtils.doubleArrayToFloatArray(line.getY()));
    }

    public static XYCircle toLuceneXYCircle(Circle circle) {
        return new XYCircle((float)circle.getX(), (float)circle.getY(), (float)circle.getRadiusMeters());
    }

    private static float[] doubleArrayToFloatArray(double[] array) {
        float[] result = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = (float)array[i];
        }
        return result;
    }

    public static CartesianPoint parseCartesianPointObject(XContentParser parser, CartesianPoint point, boolean ignoreZValue) throws IOException {
        try (XContentSubParser subParser = new XContentSubParser(parser);){
            if (subParser.nextToken() != XContentParser.Token.FIELD_NAME) {
                throw new SkyliteParseException(ERR_MSG_INVALID_TOKEN, new Object[]{subParser.currentToken()});
            }
            String field = subParser.currentName();
            if (CartesianPoint.X_FIELD.equals(field) || CartesianPoint.Y_FIELD.equals(field)) {
                ShapeUtils.parseCartesianPointObjectBasicFields(subParser, point);
            } else if (GEOJSON_TYPE.equals(field) || GEOJSON_COORDS.equals(field)) {
                ShapeUtils.parseCartesianJSONFields(subParser, point, ignoreZValue);
            } else {
                throw new SkyliteParseException(ERR_MSG_INVALID_FIELDS, new Object[0]);
            }
            CartesianPoint cartesianPoint = point;
            return cartesianPoint;
        }
    }

    private static CartesianPoint parseCartesianPointObjectBasicFields(XContentParser parser, CartesianPoint point) throws IOException {
        HashMap<String, Float> data = new HashMap<String, Float>();
        block5: for (int i = 0; i < 2; ++i) {
            if (i != 0) {
                parser.nextToken();
            }
            if (parser.currentToken() != XContentParser.Token.FIELD_NAME) break;
            String field = parser.currentName();
            if (!CartesianPoint.X_FIELD.equals(field) && !CartesianPoint.Y_FIELD.equals(field)) {
                throw new SkyliteParseException(ERR_MSG_INVALID_FIELDS, new Object[0]);
            }
            switch (parser.nextToken()) {
                case VALUE_NUMBER: 
                case VALUE_STRING: {
                    try {
                        data.put(field, Float.valueOf(parser.floatValue(true)));
                        continue block5;
                    }
                    catch (NumberFormatException e) {
                        throw new SkyliteParseException("[{}] and [{}] must be valid float values", (Throwable)e, CartesianPoint.X_FIELD, CartesianPoint.Y_FIELD);
                    }
                }
                default: {
                    throw new SkyliteParseException("{} must be a number", field);
                }
            }
        }
        if (data.get(CartesianPoint.X_FIELD) == null) {
            throw new SkyliteParseException("field [{}] missing", CartesianPoint.X_FIELD);
        }
        if (data.get(CartesianPoint.Y_FIELD) == null) {
            throw new SkyliteParseException("field [{}] missing", CartesianPoint.Y_FIELD);
        }
        return point.reset(((Float)data.get(CartesianPoint.X_FIELD)).floatValue(), ((Float)data.get(CartesianPoint.Y_FIELD)).floatValue());
    }

    private static CartesianPoint parseCartesianJSONFields(XContentParser parser, CartesianPoint point, boolean ignoreZValue) throws IOException {
        boolean hasTypePoint = false;
        boolean hasCoordinates = false;
        for (int i = 0; i < 2; ++i) {
            if (i != 0) {
                parser.nextToken();
            }
            if (parser.currentToken() != XContentParser.Token.FIELD_NAME) {
                if (!hasTypePoint) {
                    throw new SkyliteParseException("field [{}] missing", GEOJSON_TYPE);
                }
                if (!hasCoordinates) {
                    throw new SkyliteParseException("field [{}] missing", GEOJSON_COORDS);
                }
            }
            if (GEOJSON_TYPE.equals(parser.currentName())) {
                if (parser.nextToken() != XContentParser.Token.VALUE_STRING) {
                    throw new SkyliteParseException("{} must be a string", GEOJSON_TYPE);
                }
                if (!ShapeType.POINT.name().equalsIgnoreCase(parser.text())) {
                    throw new SkyliteParseException("{} must be Point", GEOJSON_TYPE);
                }
                hasTypePoint = true;
                continue;
            }
            if (GEOJSON_COORDS.equals(parser.currentName())) {
                if (parser.nextToken() != XContentParser.Token.START_ARRAY) {
                    throw new SkyliteParseException("{} must be an array", GEOJSON_COORDS);
                }
                ShapeUtils.parseCartesianPointArray(parser, point, ignoreZValue);
                hasCoordinates = true;
                continue;
            }
            throw new SkyliteParseException(ERR_MSG_INVALID_FIELDS, new Object[0]);
        }
        return point;
    }

    private static CartesianPoint parseCartesianPointArray(XContentParser parser, CartesianPoint point, boolean ignoreZValue) throws IOException {
        try (XContentSubParser subParser = new XContentSubParser(parser);){
            float x = Float.NaN;
            float y = Float.NaN;
            int element = 0;
            while (subParser.nextToken() != XContentParser.Token.END_ARRAY) {
                if (parser.currentToken() != XContentParser.Token.VALUE_NUMBER) {
                    throw new SkyliteParseException("numeric value expected", new Object[0]);
                }
                if (++element == 1) {
                    x = parser.floatValue();
                    continue;
                }
                if (element == 2) {
                    y = parser.floatValue();
                    continue;
                }
                if (element == 3) {
                    GeoPoint.assertZValue(ignoreZValue, parser.doubleValue());
                    continue;
                }
                throw new SkyliteParseException("[point] field type does not accept more than 3 values", new Object[0]);
            }
            if (element < 2) {
                throw new SkyliteParseException("[point] field type should have at least two dimensions", new Object[0]);
            }
            CartesianPoint cartesianPoint = point.reset(x, y);
            return cartesianPoint;
        }
    }
}

