/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.http;

import io.skylite.common.network.InetAddresses;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.common.transport.BoundTransportAddress;
import io.skylite.core.common.transport.TransportAddress;
import io.skylite.core.common.unit.ByteSizeValue;
import io.skylite.core.service.ReportingService;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;

public class HttpInfo
implements ReportingService.Info {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(HttpInfo.class);
    private static final boolean CNAME_IN_PUBLISH_HOST = System.getProperty("opensearch.http.cname_in_publish_address") != null;
    private final BoundTransportAddress address;
    private final long maxContentLength;

    public HttpInfo(StreamInput in) throws IOException {
        this(new BoundTransportAddress(in), in.readLong());
    }

    public HttpInfo(BoundTransportAddress address, long maxContentLength) {
        this.address = address;
        this.maxContentLength = maxContentLength;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.address.writeTo(out);
        out.writeLong(this.maxContentLength);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("http");
        builder.array("bound_address", this.address.boundAddresses());
        TransportAddress publishAddress = this.address.publishAddress();
        Object publishAddressString = publishAddress.toString();
        String hostString = publishAddress.address().getHostString();
        if (CNAME_IN_PUBLISH_HOST) {
            deprecationLogger.deprecate("cname_in_publish_address", "opensearch.http.cname_in_publish_address system property is deprecated and no longer affects http.publish_address formatting. Remove this property to get rid of this deprecation warning.", new Object[0]);
        }
        if (!InetAddresses.isInetAddress((String)hostString)) {
            publishAddressString = hostString + "/" + publishAddress.toString();
        }
        builder.field("publish_address", (String)publishAddressString);
        builder.humanReadableField("max_content_length_in_bytes", "max_content_length", this.maxContentLength());
        builder.endObject();
        return builder;
    }

    public BoundTransportAddress address() {
        return this.address;
    }

    public BoundTransportAddress getAddress() {
        return this.address();
    }

    public ByteSizeValue maxContentLength() {
        return new ByteSizeValue(this.maxContentLength);
    }

    public ByteSizeValue getMaxContentLength() {
        return this.maxContentLength();
    }

    static final class Fields {
        static final String HTTP = "http";
        static final String BOUND_ADDRESS = "bound_address";
        static final String PUBLISH_ADDRESS = "publish_address";
        static final String MAX_CONTENT_LENGTH = "max_content_length";
        static final String MAX_CONTENT_LENGTH_IN_BYTES = "max_content_length_in_bytes";

        Fields() {
        }
    }
}

