/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.http;

import io.skylite.core.http.HttpRequestSigner;
import io.skylite.core.http.NoOpHttpRequestSigner;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ServiceLoader;

public class HttpSignerRegistry {
    private static final Map<String, Class<?>> SIGNER_LEDGER;
    private static final Map<Class<?>, HttpRequestSigner> SIGNER_REGISTRY;
    private static HttpRequestSigner HTTP_REQUEST_SIGNER;

    public static HttpRequestSigner getSigner(String apiName) {
        Class<?> clazz = SIGNER_LEDGER.get(apiName);
        if (clazz == null) {
            throw new IllegalArgumentException("No HttpRequestSigner is registered for setting key [" + apiName + "]. Options are [" + String.join((CharSequence)", ", SIGNER_LEDGER.keySet()));
        }
        HttpRequestSigner signer = SIGNER_REGISTRY.get(clazz);
        if (signer == null) {
            throw new IllegalStateException("Inconsistent registry state: No signer instance found for class [" + String.valueOf(clazz) + "]");
        }
        return signer;
    }

    public static void setHttpRequestSigner(String apiName) {
        HTTP_REQUEST_SIGNER = HttpSignerRegistry.getSigner(apiName);
    }

    public static HttpRequestSigner getHttpSigner() {
        return HTTP_REQUEST_SIGNER;
    }

    static {
        LinkedHashMap signerLedger = new LinkedHashMap();
        LinkedHashMap signers = new LinkedHashMap();
        for (HttpRequestSigner signer : ServiceLoader.load(HttpRequestSigner.class, HttpSignerRegistry.class.getClassLoader())) {
            Class<?> clazz = signer.getClazz();
            String apiName = signer.getApiName();
            if (signers.putIfAbsent(clazz, signer) != null) {
                throw new IllegalArgumentException("HttpRequestSigner class [" + String.valueOf(clazz) + "] already exists.");
            }
            if (signerLedger.putIfAbsent(apiName, clazz) == null) continue;
            throw new IllegalArgumentException("HttpRequestSigner api name [" + apiName + "] cannot be registered twice - existing registration: [" + String.valueOf(signerLedger.get(apiName)) + "]");
        }
        SIGNER_LEDGER = Map.copyOf(signerLedger);
        SIGNER_REGISTRY = Map.copyOf(signers);
        HTTP_REQUEST_SIGNER = (HttpRequestSigner)signers.get(NoOpHttpRequestSigner.class);
    }
}

