/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.http;

import io.skylite.common.Nullable;
import io.skylite.core.common.bytes.BytesArray;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.http.HttpRequest;
import io.skylite.core.http.HttpResponse;
import io.skylite.core.rest.RestRequest;
import io.skylite.core.rest.RestStatus;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MutableHttpRequest
implements HttpRequest {
    private final RestRequest.Method method;
    private final URI uri;
    private final Map<String, List<String>> headers;
    private final BytesReference content;
    private final HttpRequest.HttpVersion protocolVersion;

    private MutableHttpRequest(Builder builder) {
        this.method = builder.method;
        this.uri = builder.uri;
        this.headers = new HashMap<String, List<String>>(builder.headers);
        this.content = builder.content;
        this.protocolVersion = builder.protocolVersion;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(HttpRequest request) {
        Builder builder = new Builder().method(request.method()).uri(URI.create(request.uri())).content(request.content()).protocolVersion(request.protocolVersion());
        request.getHeaders().forEach((name, values) -> {
            for (String value : values) {
                builder.addHeader((String)name, value);
            }
        });
        return builder;
    }

    public Builder toBuilder() {
        return MutableHttpRequest.builder(this);
    }

    @Override
    public RestRequest.Method method() {
        return this.method;
    }

    @Override
    public String uri() {
        return this.uri.toString();
    }

    public URI getUri() {
        return this.uri;
    }

    public String getHost() {
        return this.uri.getHost();
    }

    public String getPath() {
        return this.uri.getPath();
    }

    @Nullable
    public String getQuery() {
        return this.uri.getQuery();
    }

    public int getPort() {
        return this.uri.getPort();
    }

    public String getScheme() {
        return this.uri.getScheme();
    }

    @Override
    public BytesReference content() {
        return this.content;
    }

    public String contentAsString() {
        if (this.content == null || this.content.length() == 0) {
            return "";
        }
        return this.content.utf8ToString();
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    @Override
    public List<String> strictCookies() {
        return Collections.emptyList();
    }

    @Override
    public HttpRequest.HttpVersion protocolVersion() {
        return this.protocolVersion;
    }

    @Override
    public HttpRequest removeHeader(String header) {
        return this.toBuilder().removeHeader(header).build();
    }

    @Override
    public HttpResponse createResponse(RestStatus status, BytesReference content) {
        throw new UnsupportedOperationException("MutableHttpRequest cannot create responses");
    }

    @Override
    @Nullable
    public Exception getInboundException() {
        return null;
    }

    @Override
    public void release() {
    }

    @Override
    public HttpRequest releaseAndCopy() {
        return this;
    }

    public static class Builder {
        private RestRequest.Method method = RestRequest.Method.GET;
        private URI uri;
        private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
        private BytesReference content = BytesArray.EMPTY;
        private HttpRequest.HttpVersion protocolVersion = HttpRequest.HttpVersion.HTTP_1_1;

        public Builder method(RestRequest.Method method) {
            this.method = method;
            return this;
        }

        public Builder uri(URI uri) {
            this.uri = uri;
            return this;
        }

        public Builder uri(String uri) {
            this.uri = URI.create(uri);
            return this;
        }

        public Builder addHeader(String name, String value) {
            this.headers.computeIfAbsent(name, k -> new ArrayList()).add(value);
            return this;
        }

        public Builder setHeader(String name, String value) {
            ArrayList<String> values = new ArrayList<String>();
            values.add(value);
            this.headers.put(name, values);
            return this;
        }

        public Builder removeHeader(String name) {
            this.headers.remove(name);
            return this;
        }

        public Builder content(BytesReference content) {
            this.content = content != null ? content : BytesArray.EMPTY;
            return this;
        }

        public Builder content(String content) {
            this.content = content == null || content.isEmpty() ? BytesArray.EMPTY : new BytesArray(content.getBytes(StandardCharsets.UTF_8));
            return this;
        }

        public Builder protocolVersion(HttpRequest.HttpVersion protocolVersion) {
            this.protocolVersion = protocolVersion;
            return this;
        }

        public MutableHttpRequest build() {
            if (this.uri == null) {
                throw new IllegalStateException("URI is required");
            }
            return new MutableHttpRequest(this);
        }
    }
}

