/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.identity.tokens;

import io.skylite.core.identity.tokens.AuthToken;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public final class BasicAuthToken
implements AuthToken {
    public static final String TOKEN_IDENTIFIER = "Basic";
    private String user;
    private String password;

    public BasicAuthToken(String headerValue) {
        String base64Encoded = headerValue.substring(TOKEN_IDENTIFIER.length()).trim();
        byte[] rawDecoded = Base64.getUrlDecoder().decode(base64Encoded);
        String usernamepassword = new String(rawDecoded, StandardCharsets.UTF_8);
        String[] tokenParts = usernamepassword.split(":", 2);
        if (tokenParts.length != 2) {
            throw new IllegalStateException("Illegally formed basic authorization header " + tokenParts[0]);
        }
        this.user = tokenParts[0];
        this.password = tokenParts[1];
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String toString() {
        return "Basic auth token with user=" + this.user + ", password=" + this.password;
    }

    public void revoke() {
        this.password = "";
        this.user = "";
    }

    @Override
    public String asAuthHeaderValue() {
        if (this.user == null || this.password == null) {
            return null;
        }
        String usernamepassword = this.user + ":" + this.password;
        return Base64.getEncoder().encodeToString(usernamepassword.getBytes(StandardCharsets.UTF_8));
    }
}

