/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.identity.tokens;

import io.skylite.core.common.Strings;
import io.skylite.core.identity.tokens.AuthToken;
import io.skylite.core.identity.tokens.BasicAuthToken;
import io.skylite.core.rest.RestRequest;
import java.util.Collections;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RestTokenExtractor {
    private static final Logger logger = LogManager.getLogger(RestTokenExtractor.class);
    public static final String AUTH_HEADER_NAME = "Authorization";

    public static AuthToken extractToken(RestRequest request) {
        Optional authHeaderValue = request.getHeaders().getOrDefault(AUTH_HEADER_NAME, Collections.emptyList()).stream().findFirst();
        if (authHeaderValue.isPresent()) {
            String authHeaderValueStr = (String)authHeaderValue.get();
            if (authHeaderValueStr.startsWith("Basic")) {
                return new BasicAuthToken(authHeaderValueStr);
            }
            if (logger.isDebugEnabled()) {
                String tokenTypeTruncated = Strings.substring(authHeaderValueStr, 0, 5);
                logger.debug("An authentication header was detected but the token type was not supported " + tokenTypeTruncated);
            }
        }
        logger.trace("No auth token could be extracted");
        return null;
    }
}

