/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;

public class ReplicationStats
implements ToXContentFragment,
Writeable {
    public long maxBytesBehind;
    public long maxReplicationLag;
    public long totalBytesBehind;

    public ReplicationStats(long maxBytesBehind, long totalBytesBehind, long maxReplicationLag) {
        this.maxBytesBehind = maxBytesBehind;
        this.totalBytesBehind = totalBytesBehind;
        this.maxReplicationLag = maxReplicationLag;
    }

    public ReplicationStats(StreamInput in) throws IOException {
        this.maxBytesBehind = in.readVLong();
        this.totalBytesBehind = in.readVLong();
        this.maxReplicationLag = in.readVLong();
    }

    public ReplicationStats() {
    }

    public void add(ReplicationStats other) {
        if (other != null) {
            this.maxBytesBehind = Math.max(other.maxBytesBehind, this.maxBytesBehind);
            this.totalBytesBehind += other.totalBytesBehind;
            this.maxReplicationLag = Math.max(other.maxReplicationLag, this.maxReplicationLag);
        }
    }

    public long getMaxBytesBehind() {
        return this.maxBytesBehind;
    }

    public long getTotalBytesBehind() {
        return this.totalBytesBehind;
    }

    public long getMaxReplicationLag() {
        return this.maxReplicationLag;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.maxBytesBehind);
        out.writeVLong(this.totalBytesBehind);
        out.writeVLong(this.maxReplicationLag);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("segment_replication");
        builder.field("max_bytes_behind", this.maxBytesBehind);
        builder.field("total_bytes_behind", this.totalBytesBehind);
        builder.field("max_replication_lag", this.maxReplicationLag);
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final String SEGMENT_REPLICATION = "segment_replication";
        static final String MAX_BYTES_BEHIND = "max_bytes_behind";
        static final String TOTAL_BYTES_BEHIND = "total_bytes_behind";
        static final String MAX_REPLICATION_LAG = "max_replication_lag";

        Fields() {
        }
    }
}

