/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.analysis;

import io.skylite.core.analysis.AnalysisMode;
import io.skylite.core.analysis.AnalyzerComponents;
import io.skylite.core.analysis.CharFilterFactory;
import io.skylite.core.analysis.CustomAnalyzer;
import io.skylite.core.analysis.ReloadableCustomAnalyzer;
import io.skylite.core.analysis.TokenFilterFactory;
import io.skylite.core.analysis.TokenizerFactory;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.index.analysis.AbstractIndexAnalyzerProvider;
import io.skylite.core.settings.Settings;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;

public class CustomAnalyzerProvider
extends AbstractIndexAnalyzerProvider<Analyzer> {
    private final Settings analyzerSettings;
    private Analyzer customAnalyzer;

    public CustomAnalyzerProvider(IndexSettings indexSettings, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.analyzerSettings = settings;
    }

    public void build(Map<String, TokenizerFactory> tokenizers, Map<String, CharFilterFactory> charFilters, Map<String, TokenFilterFactory> tokenFilters) {
        this.customAnalyzer = CustomAnalyzerProvider.create(this.name(), this.analyzerSettings, tokenizers, charFilters, tokenFilters);
    }

    private static Analyzer create(String name, Settings analyzerSettings, Map<String, TokenizerFactory> tokenizers, Map<String, CharFilterFactory> charFilters, Map<String, TokenFilterFactory> tokenFilters) {
        int positionIncrementGap = 100;
        positionIncrementGap = analyzerSettings.getAsInt("position_increment_gap", positionIncrementGap);
        int offsetGap = analyzerSettings.getAsInt("offset_gap", -1);
        AnalyzerComponents components = AnalyzerComponents.createComponents(name, analyzerSettings, tokenizers, charFilters, tokenFilters);
        if (components.analysisMode().equals((Object)AnalysisMode.SEARCH_TIME)) {
            return new ReloadableCustomAnalyzer(components, positionIncrementGap, offsetGap);
        }
        return new CustomAnalyzer(components.getTokenizerFactory(), components.getCharFilters(), components.getTokenFilters(), positionIncrementGap, offsetGap);
    }

    @Override
    public Analyzer get() {
        return this.customAnalyzer;
    }
}

