/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.analysis;

import io.skylite.common.util.io.IOUtils;
import io.skylite.core.analysis.AnalyzerScope;
import io.skylite.core.analysis.NamedAnalyzer;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class IndexAnalyzers
implements Closeable {
    public static final String DEFAULT_ANALYZER_NAME = "default";
    public static final String DEFAULT_SEARCH_ANALYZER_NAME = "default_search";
    public static final String DEFAULT_SEARCH_QUOTED_ANALYZER_NAME = "default_search_quoted";
    private final Map<String, NamedAnalyzer> analyzers;
    private final Map<String, NamedAnalyzer> normalizers;
    private final Map<String, NamedAnalyzer> whitespaceNormalizers;

    public IndexAnalyzers(Map<String, NamedAnalyzer> analyzers, Map<String, NamedAnalyzer> normalizers, Map<String, NamedAnalyzer> whitespaceNormalizers) {
        Objects.requireNonNull(analyzers.get(DEFAULT_ANALYZER_NAME), "the default analyzer must be set");
        if (!analyzers.get(DEFAULT_ANALYZER_NAME).name().equals(DEFAULT_ANALYZER_NAME)) {
            throw new IllegalStateException("default analyzer must have the name [default] but was: [" + analyzers.get(DEFAULT_ANALYZER_NAME).name() + "]");
        }
        this.analyzers = Collections.unmodifiableMap(analyzers);
        this.normalizers = Collections.unmodifiableMap(normalizers);
        this.whitespaceNormalizers = Collections.unmodifiableMap(whitespaceNormalizers);
    }

    public NamedAnalyzer get(String name) {
        return this.analyzers.get(name);
    }

    public Map<String, NamedAnalyzer> getAnalyzers() {
        return this.analyzers;
    }

    public NamedAnalyzer getNormalizer(String name) {
        return this.normalizers.get(name);
    }

    public NamedAnalyzer getWhitespaceNormalizer(String name) {
        return this.whitespaceNormalizers.get(name);
    }

    public NamedAnalyzer getDefaultIndexAnalyzer() {
        return this.analyzers.get(DEFAULT_ANALYZER_NAME);
    }

    public NamedAnalyzer getDefaultSearchAnalyzer() {
        return this.analyzers.getOrDefault(DEFAULT_SEARCH_ANALYZER_NAME, this.getDefaultIndexAnalyzer());
    }

    public NamedAnalyzer getDefaultSearchQuoteAnalyzer() {
        return this.analyzers.getOrDefault(DEFAULT_SEARCH_QUOTED_ANALYZER_NAME, this.getDefaultSearchAnalyzer());
    }

    @Override
    public void close() throws IOException {
        IOUtils.close((Iterable)Stream.of(this.analyzers.values().stream(), this.normalizers.values().stream(), this.whitespaceNormalizers.values().stream()).flatMap(s -> s).filter(a -> a.scope() == AnalyzerScope.INDEX).collect(Collectors.toList()));
    }
}

