/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.engine;

import io.skylite.common.collect.MapBuilder;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.lucene.Lucene;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Base64;
import java.util.Map;
import org.apache.lucene.index.SegmentInfos;

public final class CommitStats
implements Writeable,
ToXContentFragment {
    private final Map<String, String> userData;
    private final long generation;
    private final String id;
    private final int numDocs;

    public CommitStats(SegmentInfos segmentInfos) {
        this.userData = MapBuilder.newMapBuilder().putAll(segmentInfos.getUserData()).immutableMap();
        this.generation = segmentInfos.getLastGeneration();
        this.id = Base64.getEncoder().encodeToString(segmentInfos.getId());
        this.numDocs = Lucene.getNumDocs(segmentInfos);
    }

    CommitStats(StreamInput in) throws IOException {
        MapBuilder builder = MapBuilder.newMapBuilder();
        for (int i = in.readVInt(); i > 0; --i) {
            builder.put((Object)in.readString(), (Object)in.readString());
        }
        this.userData = builder.immutableMap();
        this.generation = in.readLong();
        this.id = in.readOptionalString();
        this.numDocs = in.readInt();
    }

    public static CommitStats readOptionalCommitStatsFrom(StreamInput in) throws IOException {
        return in.readOptionalWriteable(CommitStats::new);
    }

    public Map<String, String> getUserData() {
        return this.userData;
    }

    public long getGeneration() {
        return this.generation;
    }

    public String getId() {
        return this.id;
    }

    public int getNumDocs() {
        return this.numDocs;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.userData.size());
        for (Map.Entry<String, String> entry : this.userData.entrySet()) {
            out.writeString(entry.getKey());
            out.writeString(entry.getValue());
        }
        out.writeLong(this.generation);
        out.writeOptionalString(this.id);
        out.writeInt(this.numDocs);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("commit");
        builder.field("id", this.id);
        builder.field("generation", this.generation);
        builder.field("user_data", (Object)this.userData);
        builder.field("num_docs", this.numDocs);
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final String GENERATION = "generation";
        static final String USER_DATA = "user_data";
        static final String ID = "id";
        static final String COMMIT = "commit";
        static final String NUM_DOCS = "num_docs";

        Fields() {
        }
    }
}

