/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.engine;

import io.skylite.common.SetOnce;
import io.skylite.core.index.engine.EngineOperation;
import io.skylite.core.index.translog.TranslogLocation;
import java.util.Objects;

public abstract class EngineResult {
    private final EngineOperation.TYPE operationType;
    private final Type resultType;
    private final long version;
    private final long term;
    private final long seqNo;
    private final Exception failure;
    private final SetOnce<Boolean> freeze = new SetOnce();
    private final String requiredMappingUpdate;
    private TranslogLocation translogLocation;
    private long took;

    protected EngineResult(EngineOperation.TYPE operationType, Exception failure, long version, long term, long seqNo) {
        this.operationType = operationType;
        this.failure = Objects.requireNonNull(failure);
        this.version = version;
        this.term = term;
        this.seqNo = seqNo;
        this.requiredMappingUpdate = null;
        this.resultType = Type.FAILURE;
    }

    protected EngineResult(EngineOperation.TYPE operationType, long version, long term, long seqNo) {
        this.operationType = operationType;
        this.version = version;
        this.seqNo = seqNo;
        this.term = term;
        this.failure = null;
        this.requiredMappingUpdate = null;
        this.resultType = Type.SUCCESS;
    }

    protected EngineResult(EngineOperation.TYPE operationType, String requiredMappingUpdateAsString) {
        this.operationType = operationType;
        this.version = -1L;
        this.seqNo = -2L;
        this.term = 0L;
        this.failure = null;
        this.requiredMappingUpdate = requiredMappingUpdateAsString;
        this.resultType = Type.MAPPING_UPDATE_REQUIRED;
    }

    public Type getResultType() {
        return this.resultType;
    }

    public long getVersion() {
        return this.version;
    }

    public long getSeqNo() {
        return this.seqNo;
    }

    public long getTerm() {
        return this.term;
    }

    public String getRequiredMappingUpdate() {
        return this.requiredMappingUpdate;
    }

    public TranslogLocation getTranslogLocation() {
        return this.translogLocation;
    }

    public Exception getFailure() {
        return this.failure;
    }

    public long getTook() {
        return this.took;
    }

    public EngineOperation.TYPE getOperationType() {
        return this.operationType;
    }

    public void setTranslogLocation(TranslogLocation translogLocation) {
        if (this.freeze.get() != null) {
            throw new IllegalStateException("result is already frozen");
        }
        this.translogLocation = translogLocation;
    }

    public void setTook(long took) {
        if (this.freeze.get() != null) {
            throw new IllegalStateException("result is already frozen");
        }
        this.took = took;
    }

    public void freeze() {
        this.freeze.set((Object)true);
    }

    public static enum Type {
        SUCCESS,
        FAILURE,
        MAPPING_UPDATE_REQUIRED;

    }

    public static class NoOpResult
    extends EngineResult {
        public NoOpResult(long term, long seqNo) {
            super(EngineOperation.TYPE.NO_OP, 0L, term, seqNo);
        }

        public NoOpResult(long term, long seqNo, Exception failure) {
            super(EngineOperation.TYPE.NO_OP, failure, 0L, term, seqNo);
        }
    }

    public static class DeleteResult
    extends EngineResult {
        private final boolean found;

        public DeleteResult(long version, long term, long seqNo, boolean found) {
            super(EngineOperation.TYPE.DELETE, version, term, seqNo);
            this.found = found;
        }

        public DeleteResult(Exception failure, long version, long term) {
            this(failure, version, term, -2L, false);
        }

        public DeleteResult(Exception failure, long version, long term, long seqNo, boolean found) {
            super(EngineOperation.TYPE.DELETE, failure, version, term, seqNo);
            this.found = found;
        }

        public DeleteResult(String requiredMappingUpdateAsString) {
            super(EngineOperation.TYPE.DELETE, requiredMappingUpdateAsString);
            this.found = false;
        }

        public boolean isFound() {
            return this.found;
        }
    }

    public static class IndexResult
    extends EngineResult {
        private final boolean created;

        public IndexResult(long version, long term, long seqNo, boolean created) {
            super(EngineOperation.TYPE.INDEX, version, term, seqNo);
            this.created = created;
        }

        public IndexResult(Exception failure, long version) {
            this(failure, version, 0L, -2L);
        }

        public IndexResult(Exception failure, long version, long term, long seqNo) {
            super(EngineOperation.TYPE.INDEX, failure, version, term, seqNo);
            this.created = false;
        }

        public IndexResult(String requiredMappingUpdate) {
            super(EngineOperation.TYPE.INDEX, requiredMappingUpdate);
            this.created = false;
        }

        public boolean isCreated() {
            return this.created;
        }
    }
}

