/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.engine;

import io.skylite.core.index.engine.VersionValue;
import io.skylite.core.index.translog.TranslogLocation;
import java.util.Objects;
import org.apache.lucene.util.RamUsageEstimator;

final class IndexVersionValue
extends VersionValue {
    private static final long RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(IndexVersionValue.class);
    private final TranslogLocation translogLocation;

    IndexVersionValue(TranslogLocation translogLocation, long version, long seqNo, long term) {
        super(version, seqNo, term);
        this.translogLocation = translogLocation;
    }

    @Override
    public long ramBytesUsed() {
        return RAM_BYTES_USED + RamUsageEstimator.shallowSizeOf((Object)this.translogLocation);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IndexVersionValue that = (IndexVersionValue)o;
        return Objects.equals(this.translogLocation, that.translogLocation);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.translogLocation);
    }

    @Override
    public String toString() {
        return "IndexVersionValue{version=" + this.version + ", seqNo=" + this.seqNo + ", term=" + this.term + ", location=" + String.valueOf(this.translogLocation) + "}";
    }

    @Override
    public TranslogLocation getLocation() {
        return this.translogLocation;
    }
}

