/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.engine;

import io.skylite.SkyliteException;
import io.skylite.SkyliteExceptionProvider;
import io.skylite.Version;
import io.skylite.common.CheckedFunction;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.index.engine.EngineException;
import io.skylite.core.index.engine.EngineOperation;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.rest.RestStatus;
import java.io.IOException;

public class VersionConflictEngineException
extends EngineException {
    public VersionConflictEngineException(ShardId shardId, EngineOperation op, long currentVersion, boolean deleted) {
        this(shardId, op.id(), op.versionType().explainConflictForWrites(currentVersion, op.version(), deleted));
    }

    public VersionConflictEngineException(ShardId shardId, String id, long compareAndWriteSeqNo, long compareAndWriteTerm, long currentSeqNo, long currentTerm) {
        this(shardId, id, "required seqNo [" + compareAndWriteSeqNo + "], primary term [" + compareAndWriteTerm + "]." + (String)(currentSeqNo == -2L ? " but no document was found" : " current document has seqNo [" + currentSeqNo + "] and primary term [" + currentTerm + "]"));
    }

    public VersionConflictEngineException(ShardId shardId, String id, String explanation) {
        this(shardId, "[{}]: version conflict, {}", null, id, explanation);
    }

    public VersionConflictEngineException(ShardId shardId, String msg, Throwable cause, Object ... params) {
        super(shardId, msg, cause, params);
    }

    @Override
    public RestStatus status() {
        return RestStatus.CONFLICT;
    }

    public VersionConflictEngineException(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    public Throwable fillInStackTrace() {
        return this;
    }

    public static class Registration
    implements SkyliteExceptionProvider<VersionConflictEngineException> {
        @Override
        public Class<VersionConflictEngineException> getExceptionClass() {
            return VersionConflictEngineException.class;
        }

        @Override
        public CheckedFunction<StreamInput, VersionConflictEngineException, IOException> getConstructor() {
            return VersionConflictEngineException::new;
        }

        @Override
        public Version<?> getVersionAdded() {
            return SkyliteException.UNKNOWN_VERSION_ADDED;
        }

        @Override
        public int getLegacyId() {
            return 52;
        }
    }
}

