/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.fielddata;

import io.skylite.common.Numbers;
import io.skylite.common.network.InetAddresses;
import io.skylite.common.network.NetworkAddress;
import io.skylite.core.common.io.stream.NamedWriteable;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Locale;
import java.util.Objects;
import java.util.function.LongSupplier;
import org.apache.lucene.document.InetAddressPoint;
import org.apache.lucene.util.BytesRef;

public interface DocValueFormat
extends NamedWriteable {
    public static final long MASK_2_63 = Long.MIN_VALUE;
    public static final BigInteger BIGINTEGER_2_64_MINUS_ONE = BigInteger.ONE.shiftLeft(64).subtract(BigInteger.ONE);
    public static final DocValueFormat RAW = new DocValueFormat(){

        @Override
        public String getWriteableName() {
            return "raw";
        }

        @Override
        public void writeTo(StreamOutput out) {
        }

        @Override
        public Long format(long value) {
            return value;
        }

        @Override
        public Double format(double value) {
            return value;
        }

        @Override
        public BigInteger format(BigInteger value) {
            return value;
        }

        @Override
        public String format(BytesRef value) {
            return value.utf8ToString();
        }

        @Override
        public long parseLong(String value, boolean roundUp, LongSupplier now) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException numberFormatException) {
                double d = Double.parseDouble(value);
                d = roundUp ? Math.ceil(d) : Math.floor(d);
                return Math.round(d);
            }
        }

        @Override
        public double parseDouble(String value, boolean roundUp, LongSupplier now) {
            return Double.parseDouble(value);
        }

        @Override
        public BytesRef parseBytesRef(String value) {
            return new BytesRef((CharSequence)value);
        }

        public String toString() {
            return "raw";
        }
    };
    public static final DocValueFormat BINARY = new DocValueFormat(){

        @Override
        public String getWriteableName() {
            return "binary";
        }

        @Override
        public void writeTo(StreamOutput out) {
        }

        @Override
        public String format(BytesRef value) {
            return Base64.getEncoder().withoutPadding().encodeToString(Arrays.copyOfRange(value.bytes, value.offset, value.offset + value.length));
        }

        @Override
        public BytesRef parseBytesRef(String value) {
            return new BytesRef(Base64.getDecoder().decode(value));
        }
    };
    public static final DocValueFormat BOOLEAN = new DocValueFormat(){

        @Override
        public String getWriteableName() {
            return "bool";
        }

        @Override
        public void writeTo(StreamOutput out) {
        }

        @Override
        public Boolean format(long value) {
            return value != 0L;
        }

        @Override
        public Boolean format(double value) {
            return value != 0.0;
        }

        @Override
        public long parseLong(String value, boolean roundUp, LongSupplier now) {
            switch (value) {
                case "false": {
                    return 0L;
                }
                case "true": {
                    return 1L;
                }
            }
            throw new IllegalArgumentException("Cannot parse boolean [" + value + "], expected either [true] or [false]");
        }

        @Override
        public double parseDouble(String value, boolean roundUp, LongSupplier now) {
            return this.parseLong(value, roundUp, now);
        }
    };
    public static final DocValueFormat IP = new DocValueFormat(){

        @Override
        public String getWriteableName() {
            return "ip";
        }

        @Override
        public void writeTo(StreamOutput out) {
        }

        @Override
        public String format(BytesRef value) {
            byte[] bytes = Arrays.copyOfRange(value.bytes, value.offset, value.offset + value.length);
            InetAddress inet = InetAddressPoint.decode((byte[])bytes);
            return NetworkAddress.format((InetAddress)inet);
        }

        @Override
        public BytesRef parseBytesRef(String value) {
            return new BytesRef(InetAddressPoint.encode((InetAddress)InetAddresses.forString((String)value)));
        }

        public String toString() {
            return "ip";
        }
    };
    public static final DocValueFormat UNSIGNED_LONG_SHIFTED = new DocValueFormat(){

        @Override
        public String getWriteableName() {
            return "unsigned_long_shifted";
        }

        @Override
        public void writeTo(StreamOutput out) {
        }

        public String toString() {
            return "unsigned_long_shifted";
        }

        @Override
        public long parseLong(String value, boolean roundUp, LongSupplier now) {
            long parsedValue = Long.parseUnsignedLong(value);
            return parsedValue ^ Long.MIN_VALUE;
        }

        @Override
        public BigInteger parseUnsignedLong(String value, boolean roundUp, LongSupplier now) {
            return Numbers.toUnsignedLong((String)value, (boolean)roundUp);
        }

        @Override
        public Object format(long value) {
            long formattedValue = value ^ Long.MIN_VALUE;
            if (formattedValue >= 0L) {
                return formattedValue;
            }
            return BigInteger.valueOf(formattedValue).and(BIGINTEGER_2_64_MINUS_ONE);
        }

        @Override
        public Double format(double value) {
            return value;
        }

        @Override
        public double parseDouble(String value, boolean roundUp, LongSupplier now) {
            return Double.parseDouble(value);
        }
    };
    public static final DocValueFormat UNSIGNED_LONG = new DocValueFormat(){

        @Override
        public String getWriteableName() {
            return "unsigned_long";
        }

        @Override
        public void writeTo(StreamOutput out) {
        }

        public String toString() {
            return "unsigned_long";
        }

        @Override
        public long parseLong(String value, boolean roundUp, LongSupplier now) {
            return Long.parseUnsignedLong(value);
        }

        @Override
        public BigInteger parseUnsignedLong(String value, boolean roundUp, LongSupplier now) {
            return Numbers.toUnsignedLong((String)value, (boolean)roundUp);
        }

        @Override
        public Object format(long value) {
            return Numbers.toUnsignedBigInteger((long)value);
        }

        @Override
        public BigInteger format(BigInteger value) {
            return value;
        }

        @Override
        public Double format(double value) {
            return value;
        }

        @Override
        public double parseDouble(String value, boolean roundUp, LongSupplier now) {
            return Double.parseDouble(value);
        }
    };

    default public Object format(long value) {
        throw new UnsupportedOperationException();
    }

    default public Object format(double value) {
        throw new UnsupportedOperationException();
    }

    default public BigInteger format(BigInteger value) {
        throw new UnsupportedOperationException();
    }

    default public Object format(BytesRef value) {
        throw new UnsupportedOperationException();
    }

    default public long parseLong(String value, boolean roundUp, LongSupplier now) {
        throw new UnsupportedOperationException();
    }

    default public BigInteger parseUnsignedLong(String value, boolean roundUp, LongSupplier now) {
        throw new UnsupportedOperationException();
    }

    default public double parseDouble(String value, boolean roundUp, LongSupplier now) {
        throw new UnsupportedOperationException();
    }

    default public BytesRef parseBytesRef(String value) {
        throw new UnsupportedOperationException();
    }

    public static final class Decimal
    implements DocValueFormat {
        public static final String NAME = "decimal";
        private static final DecimalFormatSymbols SYMBOLS = new DecimalFormatSymbols(Locale.ROOT);
        final String pattern;
        private final NumberFormat format;

        public Decimal(String pattern) {
            this.pattern = pattern;
            this.format = new DecimalFormat(pattern, SYMBOLS);
        }

        public Decimal(StreamInput in) throws IOException {
            this(in.readString());
        }

        @Override
        public String getWriteableName() {
            return NAME;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.pattern);
        }

        @Override
        public String format(long value) {
            return this.format.format(value);
        }

        @Override
        public BigInteger format(BigInteger value) {
            return value;
        }

        @Override
        public String format(double value) {
            if (Double.isNaN(value)) {
                return String.valueOf(Double.NaN);
            }
            return this.format.format(value);
        }

        @Override
        public long parseLong(String value, boolean roundUp, LongSupplier now) {
            Number n;
            try {
                n = this.format.parse(value);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
            if (this.format.isParseIntegerOnly()) {
                return n.longValue();
            }
            double d = n.doubleValue();
            d = roundUp ? Math.ceil(d) : Math.floor(d);
            return Math.round(d);
        }

        @Override
        public double parseDouble(String value, boolean roundUp, LongSupplier now) {
            Number n;
            try {
                n = this.format.parse(value);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
            return n.doubleValue();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Decimal that = (Decimal)o;
            return Objects.equals(this.pattern, that.pattern);
        }

        public int hashCode() {
            return Objects.hash(this.pattern);
        }
    }
}

