/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.fielddata;

import io.skylite.core.index.fielddata.BaseIndexFieldData;
import io.skylite.core.index.fielddata.LeafFieldData;
import io.skylite.core.index.shard.ShardId;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.util.Accountable;

public interface IndexFieldDataCache {
    public <FD extends LeafFieldData, IFD extends BaseIndexFieldData<FD>> FD load(LeafReaderContext var1, IFD var2) throws Exception;

    public <FD extends LeafFieldData, IFD extends BaseIndexFieldData.Global<FD>> IFD load(DirectoryReader var1, IFD var2) throws Exception;

    public void clear();

    public void clear(String var1);

    public static class None
    implements IndexFieldDataCache {
        @Override
        public <FD extends LeafFieldData, IFD extends BaseIndexFieldData<FD>> FD load(LeafReaderContext context, IFD indexFieldData) throws Exception {
            return indexFieldData.loadDirect(context);
        }

        @Override
        public <FD extends LeafFieldData, IFD extends BaseIndexFieldData.Global<FD>> IFD load(DirectoryReader indexReader, IFD indexFieldData) throws Exception {
            return (IFD)((BaseIndexFieldData.Global)((Object)indexFieldData.loadGlobalDirect(indexReader)));
        }

        @Override
        public void clear() {
        }

        @Override
        public void clear(String fieldName) {
        }
    }

    public static interface Listener {
        default public void onCache(ShardId shardId, String fieldName, Accountable ramUsage) {
        }

        default public void onRemoval(ShardId shardId, String fieldName, boolean wasEvicted, long sizeInBytes) {
        }
    }
}

