/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.fielddata;

import io.skylite.common.Nullable;
import io.skylite.core.aggregations.values.CoreValuesSourceType;
import io.skylite.core.aggregations.values.ValuesSourceType;
import io.skylite.core.common.time.DateUtils;
import io.skylite.core.common.util.BigArrays;
import io.skylite.core.index.fielddata.AbstractSortedNumericDocValues;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.index.fielddata.IndexFieldData;
import io.skylite.core.index.fielddata.IndexFieldDataFieldComparatorSource;
import io.skylite.core.index.fielddata.LeafNumericFieldData;
import io.skylite.core.index.fielddata.fieldcomparator.DoubleValuesComparatorSource;
import io.skylite.core.index.fielddata.fieldcomparator.FloatValuesComparatorSource;
import io.skylite.core.index.fielddata.fieldcomparator.HalfFloatValuesComparatorSource;
import io.skylite.core.index.fielddata.fieldcomparator.IntValuesComparatorSource;
import io.skylite.core.index.fielddata.fieldcomparator.LongValuesComparatorSource;
import io.skylite.core.index.fielddata.fieldcomparator.UnsignedLongValuesComparatorSource;
import io.skylite.core.search.MultiValueMode;
import io.skylite.core.search.sort.BucketedSort;
import io.skylite.core.search.sort.SortOrder;
import java.io.IOException;
import java.util.function.LongUnaryOperator;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSelector;
import org.apache.lucene.search.SortedNumericSortField;

public abstract class IndexNumericFieldData
implements IndexFieldData<LeafNumericFieldData> {
    public abstract NumericType getNumericType();

    public final SortField sortField(NumericType targetNumericType, Object missingValue, MultiValueMode sortMode, IndexFieldDataFieldComparatorSource.Nested nested, boolean reverse) {
        IndexFieldDataFieldComparatorSource source = this.comparatorSource(targetNumericType, missingValue, sortMode, nested);
        if (this.sortRequiresCustomComparator() || nested != null || sortMode != MultiValueMode.MAX && sortMode != MultiValueMode.MIN || targetNumericType != this.getNumericType()) {
            return new SortField(this.getFieldName(), (FieldComparatorSource)source, reverse);
        }
        SortedNumericSelector.Type selectorType = sortMode == MultiValueMode.MAX ? SortedNumericSelector.Type.MAX : SortedNumericSelector.Type.MIN;
        SortedNumericSortField sortField = new SortedNumericSortField(this.getFieldName(), this.getNumericType().sortFieldType, reverse, selectorType);
        sortField.setMissingValue(source.missingObject(missingValue, reverse));
        return sortField;
    }

    protected abstract boolean sortRequiresCustomComparator();

    @Override
    public final SortField sortField(Object missingValue, MultiValueMode sortMode, IndexFieldDataFieldComparatorSource.Nested nested, boolean reverse) {
        return this.sortField(this.getNumericType(), missingValue, sortMode, nested, reverse);
    }

    @Override
    public final SortField wideSortField(Object missingValue, MultiValueMode sortMode, IndexFieldDataFieldComparatorSource.Nested nested, boolean reverse) {
        if (this.getNumericType().sortFieldType == SortField.Type.INT) {
            IndexFieldDataFieldComparatorSource source = this.comparatorSource(NumericType.LONG, missingValue, sortMode, nested);
            SortedNumericSelector.Type selectorType = sortMode == MultiValueMode.MAX ? SortedNumericSelector.Type.MAX : SortedNumericSelector.Type.MIN;
            SortedNumericSortField sortField = new SortedNumericSortField(this.getFieldName(), SortField.Type.LONG, reverse, selectorType);
            sortField.setMissingValue(source.missingObject(missingValue, reverse));
            return sortField;
        }
        return this.sortField(this.getNumericType(), missingValue, sortMode, nested, reverse);
    }

    public final BucketedSort newBucketedSort(NumericType targetNumericType, BigArrays bigArrays, @Nullable Object missingValue, MultiValueMode sortMode, IndexFieldDataFieldComparatorSource.Nested nested, SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
        return this.comparatorSource(targetNumericType, missingValue, sortMode, nested).newBucketedSort(bigArrays, sortOrder, format, bucketSize, extra);
    }

    @Override
    public final BucketedSort newBucketedSort(BigArrays bigArrays, @Nullable Object missingValue, MultiValueMode sortMode, IndexFieldDataFieldComparatorSource.Nested nested, SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
        return this.newBucketedSort(this.getNumericType(), bigArrays, missingValue, sortMode, nested, sortOrder, format, bucketSize, extra);
    }

    private IndexFieldDataFieldComparatorSource comparatorSource(NumericType targetNumericType, @Nullable Object missingValue, MultiValueMode sortMode, IndexFieldDataFieldComparatorSource.Nested nested) {
        IndexFieldDataFieldComparatorSource source = switch (targetNumericType.ordinal()) {
            case 7 -> new HalfFloatValuesComparatorSource(this, missingValue, sortMode, nested);
            case 8 -> new FloatValuesComparatorSource(this, missingValue, sortMode, nested);
            case 9 -> new DoubleValuesComparatorSource(this, missingValue, sortMode, nested);
            case 10 -> new UnsignedLongValuesComparatorSource(this, missingValue, sortMode, nested);
            case 5 -> this.dateComparatorSource(missingValue, sortMode, nested);
            case 6 -> this.dateNanosComparatorSource(missingValue, sortMode, nested);
            case 4 -> new LongValuesComparatorSource(this, missingValue, sortMode, nested);
            default -> {
                if (!$assertionsDisabled && targetNumericType.isFloatingPoint()) {
                    throw new AssertionError();
                }
                yield new IntValuesComparatorSource(this, missingValue, sortMode, nested);
            }
        };
        if (targetNumericType != this.getNumericType()) {
            source.disableSkipping();
        }
        return source;
    }

    protected IndexFieldDataFieldComparatorSource dateComparatorSource(@Nullable Object missingValue, MultiValueMode sortMode, IndexFieldDataFieldComparatorSource.Nested nested) {
        return new LongValuesComparatorSource(this, missingValue, sortMode, nested);
    }

    protected IndexFieldDataFieldComparatorSource dateNanosComparatorSource(@Nullable Object missingValue, MultiValueMode sortMode, IndexFieldDataFieldComparatorSource.Nested nested) {
        return new LongValuesComparatorSource(this, missingValue, sortMode, nested, dvs -> IndexNumericFieldData.convertNumeric(dvs, DateUtils::toNanoSeconds));
    }

    protected static SortedNumericDocValues convertNumeric(final SortedNumericDocValues values, final LongUnaryOperator converter) {
        return new AbstractSortedNumericDocValues(){

            public boolean advanceExact(int target) throws IOException {
                return values.advanceExact(target);
            }

            public long nextValue() throws IOException {
                return converter.applyAsLong(values.nextValue());
            }

            public int docValueCount() {
                return values.docValueCount();
            }

            @Override
            public int nextDoc() throws IOException {
                return values.nextDoc();
            }
        };
    }

    public static enum NumericType {
        BOOLEAN(false, SortField.Type.INT, CoreValuesSourceType.BOOLEAN),
        BYTE(false, SortField.Type.INT, CoreValuesSourceType.NUMERIC),
        SHORT(false, SortField.Type.INT, CoreValuesSourceType.NUMERIC),
        INT(false, SortField.Type.INT, CoreValuesSourceType.NUMERIC),
        LONG(false, SortField.Type.LONG, CoreValuesSourceType.NUMERIC),
        DATE(false, SortField.Type.LONG, CoreValuesSourceType.DATE),
        DATE_NANOSECONDS(false, SortField.Type.LONG, CoreValuesSourceType.DATE),
        HALF_FLOAT(true, SortField.Type.LONG, CoreValuesSourceType.NUMERIC),
        FLOAT(true, SortField.Type.FLOAT, CoreValuesSourceType.NUMERIC),
        DOUBLE(true, SortField.Type.DOUBLE, CoreValuesSourceType.NUMERIC),
        UNSIGNED_LONG(false, SortField.Type.LONG, CoreValuesSourceType.NUMERIC);

        private final boolean floatingPoint;
        private final ValuesSourceType valuesSourceType;
        private final SortField.Type sortFieldType;

        private NumericType(boolean floatingPoint, SortField.Type sortFieldType, ValuesSourceType valuesSourceType) {
            this.floatingPoint = floatingPoint;
            this.sortFieldType = sortFieldType;
            this.valuesSourceType = valuesSourceType;
        }

        public final boolean isFloatingPoint() {
            return this.floatingPoint;
        }

        public final ValuesSourceType getValuesSourceType() {
            return this.valuesSourceType;
        }
    }
}

