/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.fielddata.fieldcomparator;

import io.skylite.common.Nullable;
import io.skylite.core.common.util.BigArrays;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.index.fielddata.FieldData;
import io.skylite.core.index.fielddata.IndexFieldDataFieldComparatorSource;
import io.skylite.core.index.fielddata.IndexNumericFieldData;
import io.skylite.core.index.fielddata.LeafNumericFieldData;
import io.skylite.core.index.fielddata.NumericDoubleValues;
import io.skylite.core.index.fielddata.SortedNumericDoubleValues;
import io.skylite.core.search.MultiValueMode;
import io.skylite.core.search.sort.BucketedSort;
import io.skylite.core.search.sort.SortOrder;
import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Pruning;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.comparators.DoubleComparator;
import org.apache.lucene.util.BitSet;

public class DoubleValuesComparatorSource
extends IndexFieldDataFieldComparatorSource {
    private final IndexNumericFieldData indexFieldData;

    public DoubleValuesComparatorSource(IndexNumericFieldData indexFieldData, @Nullable Object missingValue, MultiValueMode sortMode, IndexFieldDataFieldComparatorSource.Nested nested) {
        super(missingValue, sortMode, nested);
        this.indexFieldData = indexFieldData;
    }

    @Override
    public SortField.Type reducedType() {
        return SortField.Type.DOUBLE;
    }

    protected SortedNumericDoubleValues getValues(LeafReaderContext context) throws IOException {
        return ((LeafNumericFieldData)this.indexFieldData.load(context)).getDoubleValues();
    }

    private NumericDoubleValues getNumericDocValues(LeafReaderContext context, double missingValue) throws IOException {
        SortedNumericDoubleValues values = this.getValues(context);
        if (this.nested == null) {
            return FieldData.replaceMissing(this.sortMode.select(values), missingValue);
        }
        BitSet rootDocs = this.nested.rootDocs(context);
        DocIdSetIterator innerDocs = this.nested.innerDocs(context);
        int maxChildren = this.nested.getNestedSort() != null ? this.nested.getNestedSort().getMaxChildren() : Integer.MAX_VALUE;
        return this.sortMode.select(values, missingValue, rootDocs, innerDocs, context.reader().maxDoc(), maxChildren);
    }

    protected void setScorer(Scorable scorer, LeafReaderContext context) {
    }

    public FieldComparator<?> newComparator(String fieldname, int numHits, Pruning pruning, boolean reversed) {
        assert (this.indexFieldData == null || fieldname.equals(this.indexFieldData.getFieldName()));
        final double dMissingValue = (Double)this.missingObject(this.missingValue, reversed);
        return new DoubleComparator(numHits, fieldname, null, reversed, this.filterPruning(pruning)){

            public LeafFieldComparator getLeafComparator(final LeafReaderContext context) throws IOException {
                return new DoubleComparator.DoubleLeafComparator(context){

                    protected NumericDocValues getNumericDocValues(LeafReaderContext context2, String field) throws IOException {
                        return DoubleValuesComparatorSource.this.getNumericDocValues(context2, dMissingValue).getRawDoubleValues();
                    }

                    public void setScorer(Scorable scorer) {
                        DoubleValuesComparatorSource.this.setScorer(scorer, context);
                    }
                };
            }
        };
    }

    @Override
    public BucketedSort newBucketedSort(BigArrays bigArrays, final SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
        return new BucketedSort.ForDoubles(bigArrays, sortOrder, format, bucketSize, extra){
            private final double dMissingValue;
            {
                super(bigArrays, sortOrder3, format, bucketSize, extra);
                this.dMissingValue = (Double)DoubleValuesComparatorSource.this.missingObject(DoubleValuesComparatorSource.this.missingValue, sortOrder == SortOrder.DESC);
            }

            @Override
            public BucketedSort.ForDoubles.Leaf forLeaf(final LeafReaderContext ctx) throws IOException {
                return new BucketedSort.ForDoubles.Leaf(ctx){
                    private final NumericDoubleValues docValues;
                    private double docValue;
                    {
                        super(this, ctx2);
                        this.docValues = DoubleValuesComparatorSource.this.getNumericDocValues(ctx, dMissingValue);
                    }

                    @Override
                    protected boolean advanceExact(int doc) throws IOException {
                        if (this.docValues.advanceExact(doc)) {
                            this.docValue = this.docValues.doubleValue();
                            return true;
                        }
                        return false;
                    }

                    @Override
                    protected double docValue() {
                        return this.docValue;
                    }
                };
            }
        };
    }
}

