/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.fielddata.fieldcomparator;

import io.skylite.common.Nullable;
import io.skylite.core.common.util.BigArrays;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.index.fielddata.FieldData;
import io.skylite.core.index.fielddata.IndexFieldDataFieldComparatorSource;
import io.skylite.core.index.fielddata.IndexNumericFieldData;
import io.skylite.core.index.fielddata.LeafNumericFieldData;
import io.skylite.core.index.fielddata.NumericDoubleValues;
import io.skylite.core.index.fielddata.SortedNumericDoubleValues;
import io.skylite.core.search.MultiValueMode;
import io.skylite.core.search.sort.BucketedSort;
import io.skylite.core.search.sort.SortOrder;
import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Pruning;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.comparators.FloatComparator;
import org.apache.lucene.util.BitSet;

public class FloatValuesComparatorSource
extends IndexFieldDataFieldComparatorSource {
    private final IndexNumericFieldData indexFieldData;

    public FloatValuesComparatorSource(IndexNumericFieldData indexFieldData, @Nullable Object missingValue, MultiValueMode sortMode, IndexFieldDataFieldComparatorSource.Nested nested) {
        super(missingValue, sortMode, nested);
        this.indexFieldData = indexFieldData;
    }

    @Override
    public SortField.Type reducedType() {
        return SortField.Type.FLOAT;
    }

    private NumericDoubleValues getNumericDocValues(LeafReaderContext context, float missingValue) throws IOException {
        SortedNumericDoubleValues values = ((LeafNumericFieldData)this.indexFieldData.load(context)).getDoubleValues();
        if (this.nested == null) {
            return FieldData.replaceMissing(this.sortMode.select(values), missingValue);
        }
        BitSet rootDocs = this.nested.rootDocs(context);
        DocIdSetIterator innerDocs = this.nested.innerDocs(context);
        int maxChildren = this.nested.getNestedSort() != null ? this.nested.getNestedSort().getMaxChildren() : Integer.MAX_VALUE;
        return this.sortMode.select(values, missingValue, rootDocs, innerDocs, context.reader().maxDoc(), maxChildren);
    }

    public FieldComparator<?> newComparator(String fieldname, int numHits, Pruning pruning, boolean reversed) {
        assert (this.indexFieldData == null || fieldname.equals(this.indexFieldData.getFieldName()));
        final float fMissingValue = ((Float)this.missingObject(this.missingValue, reversed)).floatValue();
        return new FloatComparator(numHits, fieldname, null, reversed, this.filterPruning(pruning)){

            public LeafFieldComparator getLeafComparator(LeafReaderContext context) throws IOException {
                return new FloatComparator.FloatLeafComparator(context){

                    protected NumericDocValues getNumericDocValues(LeafReaderContext context, String field) throws IOException {
                        return FloatValuesComparatorSource.this.getNumericDocValues(context, fMissingValue).getRawFloatValues();
                    }
                };
            }
        };
    }

    @Override
    public BucketedSort newBucketedSort(BigArrays bigArrays, final SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
        return new BucketedSort.ForFloats(bigArrays, sortOrder, format, bucketSize, extra){
            private final float dMissingValue;
            {
                super(bigArrays, sortOrder3, format, bucketSize, extra);
                this.dMissingValue = ((Float)FloatValuesComparatorSource.this.missingObject(FloatValuesComparatorSource.this.missingValue, sortOrder == SortOrder.DESC)).floatValue();
            }

            @Override
            public boolean needsScores() {
                return false;
            }

            @Override
            public BucketedSort.ForFloats.Leaf forLeaf(final LeafReaderContext ctx) throws IOException {
                return new BucketedSort.ForFloats.Leaf(ctx){
                    private final NumericDoubleValues docValues;
                    private float docValue;
                    {
                        super(this, ctx2);
                        this.docValues = FloatValuesComparatorSource.this.getNumericDocValues(ctx, dMissingValue);
                    }

                    @Override
                    public void setScorer(Scorable scorer) {
                    }

                    @Override
                    protected boolean advanceExact(int doc) throws IOException {
                        if (this.docValues.advanceExact(doc)) {
                            this.docValue = (float)this.docValues.doubleValue();
                            return true;
                        }
                        return false;
                    }

                    @Override
                    protected float docValue() {
                        return this.docValue;
                    }
                };
            }
        };
    }
}

