/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.fielddata.fieldcomparator;

import io.skylite.common.Nullable;
import io.skylite.core.common.util.BigArrays;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.index.fielddata.FieldData;
import io.skylite.core.index.fielddata.IndexFieldDataFieldComparatorSource;
import io.skylite.core.index.fielddata.IndexNumericFieldData;
import io.skylite.core.index.fielddata.LeafNumericFieldData;
import io.skylite.core.search.MultiValueMode;
import io.skylite.core.search.sort.BucketedSort;
import io.skylite.core.search.sort.SortOrder;
import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Pruning;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.comparators.IntComparator;
import org.apache.lucene.util.BitSet;

public class IntValuesComparatorSource
extends IndexFieldDataFieldComparatorSource {
    private final IndexNumericFieldData indexFieldData;

    public IntValuesComparatorSource(IndexNumericFieldData indexFieldData, @Nullable Object missingValue, MultiValueMode sortMode, IndexFieldDataFieldComparatorSource.Nested nested) {
        super(missingValue, sortMode, nested);
        this.indexFieldData = indexFieldData;
    }

    @Override
    public SortField.Type reducedType() {
        return SortField.Type.INT;
    }

    private NumericDocValues getNumericDocValues(LeafReaderContext context, int missingValue) throws IOException {
        SortedNumericDocValues values = ((LeafNumericFieldData)this.indexFieldData.load(context)).getLongValues();
        if (this.nested == null) {
            return FieldData.replaceMissing(this.sortMode.select(values), missingValue);
        }
        BitSet rootDocs = this.nested.rootDocs(context);
        DocIdSetIterator innerDocs = this.nested.innerDocs(context);
        int maxChildren = this.nested.getNestedSort() != null ? this.nested.getNestedSort().getMaxChildren() : Integer.MAX_VALUE;
        return this.sortMode.select(values, missingValue, rootDocs, innerDocs, context.reader().maxDoc(), maxChildren);
    }

    public FieldComparator<?> newComparator(String fieldname, int numHits, Pruning pruning, boolean reversed) {
        assert (this.indexFieldData == null || fieldname.equals(this.indexFieldData.getFieldName()));
        final int iMissingValue = (Integer)this.missingObject(this.missingValue, reversed);
        return new IntComparator(numHits, fieldname, null, reversed, this.filterPruning(pruning)){

            public LeafFieldComparator getLeafComparator(LeafReaderContext context) throws IOException {
                return new IntComparator.IntLeafComparator(context){

                    protected NumericDocValues getNumericDocValues(LeafReaderContext context, String field) throws IOException {
                        return IntValuesComparatorSource.this.getNumericDocValues(context, iMissingValue);
                    }
                };
            }
        };
    }

    @Override
    public BucketedSort newBucketedSort(BigArrays bigArrays, final SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
        return new BucketedSort.ForInts(bigArrays, sortOrder, format, bucketSize, extra){
            private final int iMissingValue;
            {
                super(bigArrays, sortOrder3, format, bucketSize, extra);
                this.iMissingValue = (Integer)IntValuesComparatorSource.this.missingObject(IntValuesComparatorSource.this.missingValue, sortOrder == SortOrder.DESC);
            }

            @Override
            public BucketedSort.ForInts.Leaf forLeaf(final LeafReaderContext ctx) throws IOException {
                return new BucketedSort.ForInts.Leaf(ctx){
                    private final NumericDocValues docValues;
                    private int docValue;
                    {
                        super(this, ctx2);
                        this.docValues = IntValuesComparatorSource.this.getNumericDocValues(ctx, iMissingValue);
                    }

                    @Override
                    protected boolean advanceExact(int doc) throws IOException {
                        if (this.docValues.advanceExact(doc)) {
                            this.docValue = (int)this.docValues.longValue();
                            return true;
                        }
                        return false;
                    }

                    @Override
                    protected int docValue() {
                        return this.docValue;
                    }
                };
            }
        };
    }
}

