/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.fielddata.geo;

import io.skylite.common.Nullable;
import io.skylite.core.aggregations.values.ValuesSourceType;
import io.skylite.core.common.util.BigArrays;
import io.skylite.core.index.fielddata.BaseIndexFieldData;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.index.fielddata.IndexFieldData;
import io.skylite.core.index.fielddata.IndexFieldDataCache;
import io.skylite.core.index.fielddata.IndexFieldDataFieldComparatorSource;
import io.skylite.core.index.fielddata.geo.GeoShapeDVLeafFieldData;
import io.skylite.core.index.fielddata.geo.LeafGeoShapeFieldData;
import io.skylite.core.indices.breaker.CircuitBreakerService;
import io.skylite.core.search.MultiValueMode;
import io.skylite.core.search.sort.BucketedSort;
import io.skylite.core.search.sort.SortOrder;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.SortField;

public abstract class AbstractGeoShapeIndexFieldData
implements IndexFieldData<LeafGeoShapeFieldData> {
    protected final String fieldName;
    protected final ValuesSourceType valuesSourceType;

    AbstractGeoShapeIndexFieldData(String fieldName, ValuesSourceType valuesSourceType) {
        this.fieldName = fieldName;
        this.valuesSourceType = valuesSourceType;
    }

    @Override
    public final String getFieldName() {
        return this.fieldName;
    }

    @Override
    public ValuesSourceType getValuesSourceType() {
        return this.valuesSourceType;
    }

    @Override
    public SortField sortField(@Nullable Object missingValue, MultiValueMode sortMode, IndexFieldDataFieldComparatorSource.Nested nested, boolean reverse) {
        throw new IllegalArgumentException("can't sort on geo_shape field without using specific sorting feature, like geo_distance");
    }

    @Override
    public BucketedSort newBucketedSort(BigArrays bigArrays, Object missingValue, MultiValueMode sortMode, IndexFieldDataFieldComparatorSource.Nested nested, SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
        throw new IllegalArgumentException("can't sort on geo_shape field without using specific sorting feature, like geo_distance");
    }

    public static class Builder
    implements BaseIndexFieldData.Builder {
        private final String name;
        private final ValuesSourceType valuesSourceType;

        public Builder(String name, ValuesSourceType valuesSourceType) {
            this.name = name;
            this.valuesSourceType = valuesSourceType;
        }

        public IndexFieldData<?> build(IndexFieldDataCache cache, CircuitBreakerService breakerService) {
            return new GeoShapeIndexFieldData(this.name, this.valuesSourceType);
        }
    }

    public static class GeoShapeIndexFieldData
    extends AbstractGeoShapeIndexFieldData {
        public GeoShapeIndexFieldData(String fieldName, ValuesSourceType valuesSourceType) {
            super(fieldName, valuesSourceType);
        }

        @Override
        public LeafGeoShapeFieldData load(LeafReaderContext context) {
            return new GeoShapeDVLeafFieldData(context.reader(), this.fieldName);
        }

        @Override
        public LeafGeoShapeFieldData loadDirect(LeafReaderContext context) throws Exception {
            return this.load(context);
        }

        @Override
        public BaseIndexFieldData.Global<LeafGeoShapeFieldData> loadGlobal(DirectoryReader indexReader) {
            throw new UnsupportedOperationException("Global loading is not supported for GeoShape fields");
        }

        @Override
        public BaseIndexFieldData.Global<LeafGeoShapeFieldData> loadGlobalDirect(DirectoryReader indexReader) throws Exception {
            return this.loadGlobal(indexReader);
        }
    }
}

