/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.fielddata.geo;

import io.skylite.common.Nullable;
import io.skylite.core.aggregations.values.ValuesSourceType;
import io.skylite.core.common.util.BigArrays;
import io.skylite.core.index.fielddata.BaseIndexFieldData;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.index.fielddata.IndexFieldData;
import io.skylite.core.index.fielddata.IndexFieldDataCache;
import io.skylite.core.index.fielddata.IndexFieldDataFieldComparatorSource;
import io.skylite.core.index.fielddata.geo.IndexGeoPointFieldData;
import io.skylite.core.index.fielddata.geo.LatLonPointDVLeafFieldData;
import io.skylite.core.index.fielddata.geo.LeafGeoPointFieldData;
import io.skylite.core.indices.breaker.CircuitBreakerService;
import io.skylite.core.search.MultiValueMode;
import io.skylite.core.search.sort.BucketedSort;
import io.skylite.core.search.sort.SortOrder;
import org.apache.lucene.document.LatLonDocValuesField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.SortField;

public abstract class AbstractLatLonPointIndexFieldData
implements IndexGeoPointFieldData {
    protected final String fieldName;
    protected final ValuesSourceType valuesSourceType;

    AbstractLatLonPointIndexFieldData(String fieldName, ValuesSourceType valuesSourceType) {
        this.fieldName = fieldName;
        this.valuesSourceType = valuesSourceType;
    }

    @Override
    public final String getFieldName() {
        return this.fieldName;
    }

    @Override
    public ValuesSourceType getValuesSourceType() {
        return this.valuesSourceType;
    }

    @Override
    public SortField sortField(@Nullable Object missingValue, MultiValueMode sortMode, IndexFieldDataFieldComparatorSource.Nested nested, boolean reverse) {
        throw new IllegalArgumentException("can't sort on geo_point field without using specific sorting feature, like geo_distance");
    }

    @Override
    public BucketedSort newBucketedSort(BigArrays bigArrays, Object missingValue, MultiValueMode sortMode, IndexFieldDataFieldComparatorSource.Nested nested, SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
        throw new IllegalArgumentException("can't sort on geo_point field without using specific sorting feature, like geo_distance");
    }

    public static class Builder
    implements BaseIndexFieldData.Builder {
        private final String name;
        private final ValuesSourceType valuesSourceType;

        public Builder(String name, ValuesSourceType valuesSourceType) {
            this.name = name;
            this.valuesSourceType = valuesSourceType;
        }

        public IndexFieldData<?> build(IndexFieldDataCache cache, CircuitBreakerService breakerService) {
            return new LatLonPointIndexFieldData(this.name, this.valuesSourceType);
        }
    }

    public static class LatLonPointIndexFieldData
    extends AbstractLatLonPointIndexFieldData {
        public LatLonPointIndexFieldData(String fieldName, ValuesSourceType valuesSourceType) {
            super(fieldName, valuesSourceType);
        }

        @Override
        public LeafGeoPointFieldData load(LeafReaderContext context) {
            LeafReader reader = context.reader();
            FieldInfo info = reader.getFieldInfos().fieldInfo(this.fieldName);
            if (info != null) {
                LatLonPointIndexFieldData.checkCompatible(info);
            }
            return new LatLonPointDVLeafFieldData(reader, this.fieldName);
        }

        @Override
        public LeafGeoPointFieldData loadDirect(LeafReaderContext context) throws Exception {
            return this.load(context);
        }

        @Override
        public BaseIndexFieldData.Global<LeafGeoPointFieldData> loadGlobal(DirectoryReader indexReader) {
            throw new UnsupportedOperationException("Global loading is not supported for LatLonPoint fields");
        }

        @Override
        public BaseIndexFieldData.Global<LeafGeoPointFieldData> loadGlobalDirect(DirectoryReader indexReader) throws Exception {
            return this.loadGlobal(indexReader);
        }

        static void checkCompatible(FieldInfo fieldInfo) {
            if (fieldInfo.getDocValuesType() != DocValuesType.NONE && fieldInfo.getDocValuesType() != LatLonDocValuesField.TYPE.docValuesType()) {
                throw new IllegalArgumentException("field=\"" + fieldInfo.name + "\" was indexed with docValuesType=" + String.valueOf(fieldInfo.getDocValuesType()) + " but this type has docValuesType=" + String.valueOf(LatLonDocValuesField.TYPE.docValuesType()) + ", is the field really a LatLonDocValuesField?");
            }
        }
    }
}

