/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.fielddata.geo;

import io.skylite.common.geometry.utils.Geohash;
import io.skylite.core.geo.GeoPoint;
import io.skylite.core.geo.GeoUtils;
import io.skylite.core.index.fielddata.ScriptDocValues;
import io.skylite.core.index.fielddata.SortedBinaryDocValues;
import io.skylite.core.index.fielddata.geo.GeoFieldData;
import io.skylite.core.index.fielddata.geo.LeafGeoPointFieldData;
import io.skylite.core.index.fielddata.geo.MultiGeoPointValues;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.ArrayUtil;

public abstract class AbstractLeafGeoPointFieldData
implements LeafGeoPointFieldData {
    @Override
    public final SortedBinaryDocValues getBytesValues() {
        return GeoFieldData.toString(this.getGeoPointValues());
    }

    public final GeoPoints getScriptValues() {
        return new GeoPoints(this.getGeoPointValues());
    }

    public static LeafGeoPointFieldData empty(int maxDoc) {
        return new AbstractLeafGeoPointFieldData(){

            public long ramBytesUsed() {
                return 0L;
            }

            public Collection<Accountable> getChildResources() {
                return Collections.emptyList();
            }

            public void close() {
            }

            @Override
            public MultiGeoPointValues getGeoPointValues() {
                return GeoFieldData.emptyMultiGeoPoints();
            }
        };
    }

    public static final class GeoPoints
    extends ScriptDocValues<GeoPoint> {
        private final MultiGeoPointValues in;
        private GeoPoint[] values = new GeoPoint[0];
        private int count;

        public GeoPoints(MultiGeoPointValues in) {
            this.in = in;
        }

        @Override
        public void setNextDocId(int docId) throws IOException {
            if (this.in.advanceExact(docId)) {
                this.resize(this.in.docValueCount());
                for (int i = 0; i < this.count; ++i) {
                    GeoPoint point = this.in.nextValue();
                    this.values[i] = new GeoPoint(point.lat(), point.lon());
                }
            } else {
                this.resize(0);
            }
        }

        protected void resize(int newSize) {
            this.count = newSize;
            if (newSize > this.values.length) {
                int oldLength = this.values.length;
                this.values = (GeoPoint[])ArrayUtil.grow((Object[])this.values, (int)this.count);
                for (int i = oldLength; i < this.values.length; ++i) {
                    this.values[i] = new GeoPoint();
                }
            }
        }

        public GeoPoint getValue() {
            return this.get(0);
        }

        public double getLat() {
            return this.getValue().lat();
        }

        public double[] getLats() {
            double[] lats = new double[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                lats[i] = this.get(i).lat();
            }
            return lats;
        }

        public double[] getLons() {
            double[] lons = new double[this.size()];
            for (int i = 0; i < this.size(); ++i) {
                lons[i] = this.get(i).lon();
            }
            return lons;
        }

        public double getLon() {
            return this.getValue().lon();
        }

        @Override
        public GeoPoint get(int index) {
            if (this.count == 0) {
                throw new IllegalStateException("A document doesn't have a value for a field! Use doc[<field>].size()==0 to check if a document is missing a field!");
            }
            GeoPoint point = this.values[index];
            return new GeoPoint(point.lat(), point.lon());
        }

        @Override
        public int size() {
            return this.count;
        }

        public double arcDistance(double lat, double lon) {
            GeoPoint point = this.getValue();
            return GeoUtils.arcDistance(point.lat(), point.lon(), lat, lon);
        }

        public double arcDistanceWithDefault(double lat, double lon, double defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.arcDistance(lat, lon);
        }

        public double planeDistance(double lat, double lon) {
            GeoPoint point = this.getValue();
            return GeoUtils.planeDistance(point.lat(), point.lon(), lat, lon);
        }

        public double planeDistanceWithDefault(double lat, double lon, double defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.planeDistance(lat, lon);
        }

        public double geohashDistance(String geohash) {
            GeoPoint point = this.getValue();
            return GeoUtils.arcDistance(point.lat(), point.lon(), Geohash.decodeLatitude((String)geohash), Geohash.decodeLongitude((String)geohash));
        }

        public double geohashDistanceWithDefault(String geohash, double defaultValue) {
            if (this.isEmpty()) {
                return defaultValue;
            }
            return this.geohashDistance(geohash);
        }
    }
}

