/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.fielddata.geo;

import io.skylite.common.index.fielddata.DocValueBits;
import io.skylite.core.geo.GeoPoint;
import io.skylite.core.index.fielddata.FieldData;
import io.skylite.core.index.fielddata.SortedBinaryDocValues;
import io.skylite.core.index.fielddata.geo.GeoPointValues;
import io.skylite.core.index.fielddata.geo.GeoShapeValue;
import io.skylite.core.index.fielddata.geo.MultiGeoPointValues;
import io.skylite.core.index.fielddata.geo.SingletonMultiGeoPointValues;
import java.io.IOException;
import java.util.List;

public final class GeoFieldData {
    private GeoFieldData() {
    }

    public static GeoPointValues emptyGeoPoint() {
        return new GeoPointValues(){

            @Override
            public boolean advanceExact(int doc) throws IOException {
                return false;
            }

            @Override
            public GeoPoint geoPointValue() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static MultiGeoPointValues emptyMultiGeoPoints() {
        return GeoFieldData.singleton(GeoFieldData.emptyGeoPoint());
    }

    public static GeoShapeValue emptyGeoShape() {
        return new GeoShapeValue.EmptyGeoShapeValue();
    }

    public static DocValueBits docsWithValue(final MultiGeoPointValues pointValues) {
        return new DocValueBits(){

            public boolean advanceExact(int doc) throws IOException {
                return pointValues.advanceExact(doc);
            }
        };
    }

    public static DocValueBits docsWithValue(final GeoShapeValue shapeValues) {
        return new DocValueBits(){

            public boolean advanceExact(int doc) throws IOException {
                return shapeValues.advanceExact(doc);
            }
        };
    }

    public static MultiGeoPointValues singleton(GeoPointValues values) {
        return new SingletonMultiGeoPointValues(values);
    }

    public static GeoPointValues unwrapSingleton(MultiGeoPointValues values) {
        if (values instanceof SingletonMultiGeoPointValues) {
            return ((SingletonMultiGeoPointValues)values).getGeoPointValues();
        }
        return null;
    }

    public static SortedBinaryDocValues toString(final MultiGeoPointValues values) {
        return FieldData.toString(new FieldData.ToStringValues(){

            @Override
            public boolean advanceExact(int doc) throws IOException {
                return values.advanceExact(doc);
            }

            @Override
            public void get(List<CharSequence> list) throws IOException {
                int count = values.docValueCount();
                for (int i = 0; i < count; ++i) {
                    list.add(values.nextValue().toString());
                }
            }
        });
    }

    public static SortedBinaryDocValues toString(final GeoShapeValue geoShapeValue) {
        return FieldData.toString(new FieldData.ToStringValues(){

            @Override
            public boolean advanceExact(int doc) throws IOException {
                return geoShapeValue.advanceExact(doc);
            }

            @Override
            public void get(List<CharSequence> list) throws IOException {
                list.add(geoShapeValue.nextValue().toString());
            }
        });
    }
}

