/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.fielddata.ordinals;

import java.io.IOException;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongValues;

final class GlobalOrdinalMapping
extends SortedSetDocValues {
    private final SortedSetDocValues values;
    private final OrdinalMap ordinalMap;
    private final LongValues mapping;
    private final TermsEnum[] lookups;

    GlobalOrdinalMapping(OrdinalMap ordinalMap, SortedSetDocValues values, TermsEnum[] lookups, int segmentIndex) {
        this.values = values;
        this.lookups = lookups;
        this.ordinalMap = ordinalMap;
        this.mapping = ordinalMap.getGlobalOrds(segmentIndex);
    }

    public long getValueCount() {
        return this.ordinalMap.getValueCount();
    }

    public long getGlobalOrd(long segmentOrd) {
        return this.mapping.get(segmentOrd);
    }

    public boolean advanceExact(int target) throws IOException {
        return this.values.advanceExact(target);
    }

    public long nextOrd() throws IOException {
        return this.getGlobalOrd(this.values.nextOrd());
    }

    public BytesRef lookupOrd(long globalOrd) throws IOException {
        long segmentOrd = this.ordinalMap.getFirstSegmentOrd(globalOrd);
        int readerIndex = this.ordinalMap.getFirstSegmentNumber(globalOrd);
        this.lookups[readerIndex].seekExact(segmentOrd);
        return this.lookups[readerIndex].term();
    }

    public int docID() {
        return this.values.docID();
    }

    public int nextDoc() throws IOException {
        return this.values.nextDoc();
    }

    public int advance(int target) throws IOException {
        return this.values.advance(target);
    }

    public long cost() {
        return this.values.cost();
    }

    public int docValueCount() {
        return this.values.docValueCount();
    }
}

