/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.fielddata.plain;

import io.skylite.core.common.io.stream.BytesStreamInput;
import io.skylite.core.index.fielddata.LeafFieldData;
import io.skylite.core.index.fielddata.SortedBinaryDocValues;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BytesRef;

public abstract class AbstractBinaryDVLeafFieldData
implements LeafFieldData {
    private final BinaryDocValues values;

    AbstractBinaryDVLeafFieldData(BinaryDocValues values) {
        this.values = values;
    }

    public long ramBytesUsed() {
        return 0L;
    }

    public Collection<Accountable> getChildResources() {
        return Collections.emptyList();
    }

    @Override
    public SortedBinaryDocValues getBytesValues() {
        return new SortedBinaryDocValues(){
            int count;
            final BytesStreamInput in = new BytesStreamInput();
            final BytesRef scratch = new BytesRef();

            @Override
            public boolean advanceExact(int doc) throws IOException {
                if (AbstractBinaryDVLeafFieldData.this.values.advanceExact(doc)) {
                    BytesRef bytes = AbstractBinaryDVLeafFieldData.this.values.binaryValue();
                    assert (bytes.length > 0);
                    this.in.reset(bytes.bytes, bytes.offset, bytes.length);
                    this.count = this.in.readVInt();
                    this.scratch.bytes = bytes.bytes;
                    return true;
                }
                return false;
            }

            @Override
            public int docValueCount() {
                return this.count;
            }

            @Override
            public BytesRef nextValue() throws IOException {
                this.scratch.length = this.in.readVInt();
                this.scratch.offset = this.in.getPosition();
                this.in.setPosition(this.scratch.offset + this.scratch.length);
                return this.scratch;
            }
        };
    }

    public void close() {
    }
}

