/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.fielddata.plain;

import io.skylite.common.Nullable;
import io.skylite.core.aggregations.values.ValuesSourceType;
import io.skylite.core.common.util.BigArrays;
import io.skylite.core.index.fielddata.BaseIndexFieldData;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.index.fielddata.IndexFieldData;
import io.skylite.core.index.fielddata.IndexFieldDataCache;
import io.skylite.core.index.fielddata.IndexFieldDataFieldComparatorSource;
import io.skylite.core.index.fielddata.fieldcomparator.BytesRefFieldComparatorSource;
import io.skylite.core.index.fielddata.plain.BinaryDVLeafFieldData;
import io.skylite.core.indices.breaker.CircuitBreakerService;
import io.skylite.core.search.MultiValueMode;
import io.skylite.core.search.sort.BucketedSort;
import io.skylite.core.search.sort.SortOrder;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.SortField;

public class BinaryIndexFieldData
implements IndexFieldData<BinaryDVLeafFieldData> {
    protected final String fieldName;
    protected final ValuesSourceType valuesSourceType;

    public BinaryIndexFieldData(String fieldName, ValuesSourceType valuesSourceType) {
        this.fieldName = fieldName;
        this.valuesSourceType = valuesSourceType;
    }

    @Override
    public final String getFieldName() {
        return this.fieldName;
    }

    @Override
    public ValuesSourceType getValuesSourceType() {
        return this.valuesSourceType;
    }

    @Override
    public BinaryDVLeafFieldData load(LeafReaderContext context) {
        return new BinaryDVLeafFieldData(context.reader(), this.fieldName);
    }

    @Override
    public BinaryDVLeafFieldData loadDirect(LeafReaderContext context) throws Exception {
        return this.load(context);
    }

    @Override
    public BaseIndexFieldData.Global<BinaryDVLeafFieldData> loadGlobal(DirectoryReader indexReader) {
        throw new UnsupportedOperationException("Global loading is not supported for binary fields");
    }

    @Override
    public BaseIndexFieldData.Global<BinaryDVLeafFieldData> loadGlobalDirect(DirectoryReader indexReader) throws Exception {
        return this.loadGlobal(indexReader);
    }

    @Override
    public SortField sortField(@Nullable Object missingValue, MultiValueMode sortMode, IndexFieldDataFieldComparatorSource.Nested nested, boolean reverse) {
        BytesRefFieldComparatorSource source = new BytesRefFieldComparatorSource(this, missingValue, sortMode, nested);
        return new SortField(this.getFieldName(), (FieldComparatorSource)source, reverse);
    }

    @Override
    public BucketedSort newBucketedSort(BigArrays bigArrays, Object missingValue, MultiValueMode sortMode, IndexFieldDataFieldComparatorSource.Nested nested, SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
        throw new IllegalArgumentException("only supported on numeric fields");
    }

    public static class Builder
    implements BaseIndexFieldData.Builder {
        private final String name;
        private final ValuesSourceType valuesSourceType;

        public Builder(String name, ValuesSourceType valuesSourceType) {
            this.name = name;
            this.valuesSourceType = valuesSourceType;
        }

        public BinaryIndexFieldData build(IndexFieldDataCache cache, CircuitBreakerService breakerService) {
            return new BinaryIndexFieldData(this.name, this.valuesSourceType);
        }
    }
}

