/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.fielddata.plain;

import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.index.fielddata.FieldData;
import io.skylite.core.index.fielddata.FormattedDocValuesLoader;
import io.skylite.core.index.fielddata.IndexNumericFieldData;
import io.skylite.core.index.fielddata.LeafNumericFieldData;
import io.skylite.core.index.fielddata.ScriptDocValues;
import io.skylite.core.index.fielddata.SortedBinaryDocValues;
import io.skylite.core.index.fielddata.SortedNumericDoubleValues;
import io.skylite.core.index.fielddata.plain.SortedNumericIndexFieldData;
import java.io.IOException;
import org.apache.lucene.index.SortedNumericDocValues;

public abstract class LeafLongFieldData
implements LeafNumericFieldData {
    private final long ramBytesUsed;
    private final IndexNumericFieldData.NumericType numericType;

    protected LeafLongFieldData(long ramBytesUsed, IndexNumericFieldData.NumericType numericType) {
        this.ramBytesUsed = ramBytesUsed;
        this.numericType = numericType;
    }

    public long ramBytesUsed() {
        return this.ramBytesUsed;
    }

    @Override
    public final ScriptDocValues<?> getScriptValues() {
        switch (this.numericType) {
            case DATE: {
                return new ScriptDocValues.Dates(this.getLongValues(), false);
            }
            case DATE_NANOSECONDS: {
                assert (this instanceof SortedNumericIndexFieldData.NanoSecondFieldData);
                return new ScriptDocValues.Dates(((SortedNumericIndexFieldData.NanoSecondFieldData)this).getLongValuesAsNanos(), true);
            }
            case BOOLEAN: {
                return new ScriptDocValues.Booleans(this.getLongValues());
            }
        }
        return new ScriptDocValues.Longs(this.getLongValues());
    }

    @Override
    public final SortedBinaryDocValues getBytesValues() {
        return FieldData.toString(this.getLongValues());
    }

    @Override
    public final SortedNumericDoubleValues getDoubleValues() {
        return FieldData.castToDouble(this.getLongValues());
    }

    @Override
    public FormattedDocValuesLoader loadFormattedDocValues(final DocValueFormat format) {
        final SortedNumericDocValues values = this.getLongValues();
        return new FormattedDocValuesLoader(){

            @Override
            public boolean advanceExact(int docId) throws IOException {
                return values.advanceExact(docId);
            }

            @Override
            public int docValueCount() throws IOException {
                return values.docValueCount();
            }

            @Override
            public Object nextValue() throws IOException {
                return format.format(values.nextValue());
            }
        };
    }

    public void close() {
    }
}

