/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.pressure;

import io.skylite.common.unit.TimeValue;
import io.skylite.core.index.pressure.ShardIndexingPressureSettings;
import io.skylite.core.index.pressure.ShardIndexingPressureStore;
import io.skylite.core.index.pressure.ShardIndexingPressureTracker;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.Settings;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import java.util.function.LongSupplier;
import java.util.function.ToLongFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShardIndexingPressureMemoryManager {
    private static final Logger logger = LogManager.getLogger(ShardIndexingPressureMemoryManager.class);
    private final AtomicLong totalNodeLimitsBreachedRejections = new AtomicLong();
    private final AtomicLong totalLastSuccessfulRequestLimitsBreachedRejections = new AtomicLong();
    private final AtomicLong totalThroughputDegradationLimitsBreachedRejections = new AtomicLong();
    private final ShardIndexingPressureSettings shardIndexingPressureSettings;
    private final ShardIndexingPressureStore shardIndexingPressureStore;
    private volatile double lowerOperatingFactor;
    private volatile double optimalOperatingFactor;
    private volatile double upperOperatingFactor;
    private volatile TimeValue successfulRequestElapsedTimeout;
    private volatile int maxOutstandingRequests;
    private volatile double primaryAndCoordinatingThroughputDegradationLimits;
    private volatile double replicaThroughputDegradationLimits;
    private volatile double nodeSoftLimit;

    public ShardIndexingPressureMemoryManager(ShardIndexingPressureSettings shardIndexingPressureSettings, ClusterSettings clusterSettings, Settings settings) {
        this.shardIndexingPressureSettings = shardIndexingPressureSettings;
        this.shardIndexingPressureStore = new ShardIndexingPressureStore(shardIndexingPressureSettings, clusterSettings, settings);
        this.lowerOperatingFactor = ShardIndexingPressureSettings.LOWER_OPERATING_FACTOR.get(settings);
        clusterSettings.addSettingsUpdateConsumer(ShardIndexingPressureSettings.LOWER_OPERATING_FACTOR, this::setLowerOperatingFactor);
        this.optimalOperatingFactor = ShardIndexingPressureSettings.OPTIMAL_OPERATING_FACTOR.get(settings);
        clusterSettings.addSettingsUpdateConsumer(ShardIndexingPressureSettings.OPTIMAL_OPERATING_FACTOR, this::setOptimalOperatingFactor);
        this.upperOperatingFactor = ShardIndexingPressureSettings.UPPER_OPERATING_FACTOR.get(settings);
        clusterSettings.addSettingsUpdateConsumer(ShardIndexingPressureSettings.UPPER_OPERATING_FACTOR, this::setUpperOperatingFactor);
        this.successfulRequestElapsedTimeout = ShardIndexingPressureSettings.SUCCESSFUL_REQUEST_ELAPSED_TIMEOUT.get(settings);
        clusterSettings.addSettingsUpdateConsumer(ShardIndexingPressureSettings.SUCCESSFUL_REQUEST_ELAPSED_TIMEOUT, this::setSuccessfulRequestElapsedTimeout);
        this.maxOutstandingRequests = ShardIndexingPressureSettings.MAX_OUTSTANDING_REQUESTS.get(settings);
        clusterSettings.addSettingsUpdateConsumer(ShardIndexingPressureSettings.MAX_OUTSTANDING_REQUESTS, this::setMaxOutstandingRequests);
        this.primaryAndCoordinatingThroughputDegradationLimits = ShardIndexingPressureSettings.THROUGHPUT_DEGRADATION_LIMITS.get(settings);
        this.replicaThroughputDegradationLimits = this.primaryAndCoordinatingThroughputDegradationLimits * 1.5;
        clusterSettings.addSettingsUpdateConsumer(ShardIndexingPressureSettings.THROUGHPUT_DEGRADATION_LIMITS, this::setThroughputDegradationLimits);
        this.nodeSoftLimit = ShardIndexingPressureSettings.NODE_SOFT_LIMIT.get(settings);
        clusterSettings.addSettingsUpdateConsumer(ShardIndexingPressureSettings.NODE_SOFT_LIMIT, this::setNodeSoftLimit);
    }

    boolean isCoordinatingNodeLimitBreached(ShardIndexingPressureTracker tracker, long nodeTotalBytes) {
        if (nodeTotalBytes > this.shardIndexingPressureSettings.getNodePrimaryAndCoordinatingLimits()) {
            logger.debug("Node limits breached for coordinating operation [node_total_bytes={} , node_primary_and_coordinating_limits={}]", (Object)nodeTotalBytes, (Object)this.shardIndexingPressureSettings.getNodePrimaryAndCoordinatingLimits());
            this.incrementNodeLimitBreachedRejectionCount(tracker.getCoordinatingOperationTracker().getRejectionTracker());
            return true;
        }
        return false;
    }

    boolean isCoordinatingShardLimitBreached(ShardIndexingPressureTracker tracker, long nodeTotalBytes, long requestStartTime) {
        long shardPrimaryAndCoordinatingLimits;
        boolean shardMemoryLimitsBreached;
        long shardCombinedBytes = tracker.getCommonOperationTracker().getCurrentCombinedCoordinatingAndPrimaryBytes();
        boolean bl = shardMemoryLimitsBreached = (double)shardCombinedBytes / (double)(shardPrimaryAndCoordinatingLimits = tracker.getPrimaryAndCoordinatingLimits()) > this.upperOperatingFactor;
        if (shardMemoryLimitsBreached) {
            BooleanSupplier increaseShardLimitSupplier = () -> this.increaseShardLimits(tracker.getShardId(), this.shardIndexingPressureSettings.getNodePrimaryAndCoordinatingLimits(), () -> tracker.getCommonOperationTracker().getCurrentCombinedCoordinatingAndPrimaryBytes(), tracker::getPrimaryAndCoordinatingLimits, ShardIndexingPressureTracker::getPrimaryAndCoordinatingLimits, tracker::compareAndSetPrimaryAndCoordinatingLimits);
            return this.onShardLimitBreached(nodeTotalBytes, this.shardIndexingPressureSettings.getNodePrimaryAndCoordinatingLimits(), requestStartTime, tracker.getCoordinatingOperationTracker(), increaseShardLimitSupplier);
        }
        return false;
    }

    boolean isPrimaryNodeLimitBreached(ShardIndexingPressureTracker tracker, long nodeTotalBytes) {
        if (nodeTotalBytes > this.shardIndexingPressureSettings.getNodePrimaryAndCoordinatingLimits()) {
            logger.debug("Node limits breached for primary operation [node_total_bytes={}, node_primary_and_coordinating_limits={}]", (Object)nodeTotalBytes, (Object)this.shardIndexingPressureSettings.getNodePrimaryAndCoordinatingLimits());
            this.incrementNodeLimitBreachedRejectionCount(tracker.getPrimaryOperationTracker().getRejectionTracker());
            return true;
        }
        return false;
    }

    boolean isPrimaryShardLimitBreached(ShardIndexingPressureTracker tracker, long nodeTotalBytes, long requestStartTime) {
        long shardPrimaryAndCoordinatingLimits;
        boolean shardMemoryLimitsBreached;
        long shardCombinedBytes = tracker.getCommonOperationTracker().getCurrentCombinedCoordinatingAndPrimaryBytes();
        boolean bl = shardMemoryLimitsBreached = (double)shardCombinedBytes / (double)(shardPrimaryAndCoordinatingLimits = tracker.getPrimaryAndCoordinatingLimits()) > this.upperOperatingFactor;
        if (shardMemoryLimitsBreached) {
            BooleanSupplier increaseShardLimitSupplier = () -> this.increaseShardLimits(tracker.getShardId(), this.shardIndexingPressureSettings.getNodePrimaryAndCoordinatingLimits(), () -> tracker.getCommonOperationTracker().getCurrentCombinedCoordinatingAndPrimaryBytes(), tracker::getPrimaryAndCoordinatingLimits, ShardIndexingPressureTracker::getPrimaryAndCoordinatingLimits, tracker::compareAndSetPrimaryAndCoordinatingLimits);
            return this.onShardLimitBreached(nodeTotalBytes, this.shardIndexingPressureSettings.getNodePrimaryAndCoordinatingLimits(), requestStartTime, tracker.getPrimaryOperationTracker(), increaseShardLimitSupplier);
        }
        return false;
    }

    boolean isReplicaNodeLimitBreached(ShardIndexingPressureTracker tracker, long nodeReplicaBytes) {
        if (nodeReplicaBytes > this.shardIndexingPressureSettings.getNodeReplicaLimits()) {
            logger.debug("Node limits breached for replica operation [node_replica_bytes={} , node_replica_limits={}]", (Object)nodeReplicaBytes, (Object)this.shardIndexingPressureSettings.getNodeReplicaLimits());
            this.incrementNodeLimitBreachedRejectionCount(tracker.getReplicaOperationTracker().getRejectionTracker());
            return true;
        }
        return false;
    }

    boolean isReplicaShardLimitBreached(ShardIndexingPressureTracker tracker, long nodeReplicaBytes, long requestStartTime) {
        long shardReplicaLimits;
        boolean shardMemoryLimitsBreached;
        long shardReplicaBytes = tracker.getReplicaOperationTracker().getStatsTracker().getCurrentBytes();
        boolean bl = shardMemoryLimitsBreached = (double)shardReplicaBytes / (double)(shardReplicaLimits = tracker.getReplicaLimits()) > this.upperOperatingFactor;
        if (shardMemoryLimitsBreached) {
            BooleanSupplier increaseShardLimitSupplier = () -> this.increaseShardLimits(tracker.getShardId(), this.shardIndexingPressureSettings.getNodeReplicaLimits(), () -> tracker.getReplicaOperationTracker().getStatsTracker().getCurrentBytes(), tracker::getReplicaLimits, ShardIndexingPressureTracker::getReplicaLimits, tracker::compareAndSetReplicaLimits);
            return this.onShardLimitBreached(nodeReplicaBytes, this.shardIndexingPressureSettings.getNodeReplicaLimits(), requestStartTime, tracker.getReplicaOperationTracker(), increaseShardLimitSupplier);
        }
        return false;
    }

    void decreaseShardPrimaryAndCoordinatingLimits(ShardIndexingPressureTracker tracker) {
        this.decreaseShardLimits(tracker.getShardId(), () -> tracker.getCommonOperationTracker().getCurrentCombinedCoordinatingAndPrimaryBytes(), tracker::getPrimaryAndCoordinatingLimits, tracker::compareAndSetPrimaryAndCoordinatingLimits, this.shardIndexingPressureSettings.getShardPrimaryAndCoordinatingBaseLimits());
    }

    void decreaseShardReplicaLimits(ShardIndexingPressureTracker tracker) {
        this.decreaseShardLimits(tracker.getShardId(), () -> tracker.getReplicaOperationTracker().getStatsTracker().getCurrentBytes(), tracker::getReplicaLimits, tracker::compareAndSetReplicaLimits, this.shardIndexingPressureSettings.getShardReplicaBaseLimits());
    }

    ShardIndexingPressureTracker getShardIndexingPressureTracker(ShardId shardId) {
        return this.shardIndexingPressureStore.getShardIndexingPressureTracker(shardId);
    }

    Map<ShardId, ShardIndexingPressureTracker> getShardIndexingPressureHotStore() {
        return this.shardIndexingPressureStore.getShardIndexingPressureHotStore();
    }

    Map<ShardId, ShardIndexingPressureTracker> getShardIndexingPressureColdStore() {
        return this.shardIndexingPressureStore.getShardIndexingPressureColdStore();
    }

    void tryTrackerCleanupFromHotStore(ShardIndexingPressureTracker tracker, BooleanSupplier condition) {
        this.shardIndexingPressureStore.tryTrackerCleanupFromHotStore(tracker, condition);
    }

    double calculateMovingAverage(long currentAverage, double frontValue, double currentValue, int count) {
        if (count > 0) {
            return (Double.longBitsToDouble(currentAverage) * (double)count + currentValue - frontValue) / (double)count;
        }
        return currentValue;
    }

    long getTotalNodeLimitsBreachedRejections() {
        return this.totalNodeLimitsBreachedRejections.get();
    }

    long getTotalLastSuccessfulRequestLimitsBreachedRejections() {
        return this.totalLastSuccessfulRequestLimitsBreachedRejections.get();
    }

    long getTotalThroughputDegradationLimitsBreachedRejections() {
        return this.totalThroughputDegradationLimitsBreachedRejections.get();
    }

    private boolean onShardLimitBreached(long nodeTotalBytes, long nodeLimit, long requestStartTime, ShardIndexingPressureTracker.OperationTracker operationTracker, BooleanSupplier increaseShardLimitSupplier) {
        if ((double)nodeTotalBytes / (double)nodeLimit < this.nodeSoftLimit) {
            boolean isShardLimitsIncreased = increaseShardLimitSupplier.getAsBoolean();
            if (!isShardLimitsIncreased) {
                this.incrementNodeLimitBreachedRejectionCount(operationTracker.getRejectionTracker());
            }
            return !isShardLimitsIncreased;
        }
        boolean shardLastSuccessfulRequestDurationLimitsBreached = this.evaluateLastSuccessfulRequestDurationLimitsBreached(operationTracker.getPerformanceTracker(), requestStartTime);
        if (shardLastSuccessfulRequestDurationLimitsBreached) {
            operationTracker.getRejectionTracker().incrementLastSuccessfulRequestLimitsBreachedRejections();
            this.totalLastSuccessfulRequestLimitsBreachedRejections.incrementAndGet();
            return true;
        }
        boolean shardThroughputDegradationLimitsBreached = this.evaluateThroughputDegradationLimitsBreached(operationTracker.getPerformanceTracker(), operationTracker.getStatsTracker(), this.primaryAndCoordinatingThroughputDegradationLimits);
        if (shardThroughputDegradationLimitsBreached) {
            operationTracker.getRejectionTracker().incrementThroughputDegradationLimitsBreachedRejections();
            this.totalThroughputDegradationLimitsBreachedRejections.incrementAndGet();
            return true;
        }
        boolean isShardLimitsIncreased = increaseShardLimitSupplier.getAsBoolean();
        if (!isShardLimitsIncreased) {
            this.incrementNodeLimitBreachedRejectionCount(operationTracker.getRejectionTracker());
        }
        return !isShardLimitsIncreased;
    }

    private boolean increaseShardLimits(ShardId shardId, long nodeLimit, LongSupplier shardCurrentBytesSupplier, LongSupplier shardLimitSupplier, ToLongFunction<ShardIndexingPressureTracker> getShardLimitFunction, BiPredicate<Long, Long> updateShardLimitPredicate) {
        long newShardLimit;
        long currentShardLimit;
        do {
            currentShardLimit = shardLimitSupplier.getAsLong();
            long shardCurrentBytes = shardCurrentBytesSupplier.getAsLong();
            if ((double)shardCurrentBytes / (double)currentShardLimit > this.upperOperatingFactor) {
                newShardLimit = (long)((double)shardCurrentBytes / this.optimalOperatingFactor);
                long totalShardLimitsExceptCurrentShard = this.shardIndexingPressureStore.getShardIndexingPressureHotStore().entrySet().stream().filter(entry -> shardId != entry.getKey()).map(Map.Entry::getValue).mapToLong(getShardLimitFunction).sum();
                if (totalShardLimitsExceptCurrentShard + newShardLimit <= nodeLimit) continue;
                logger.debug("Failed To Increase Shard Limit [shard_detail=[{}][{}}], shard_current_limit_bytes={}, total_shard_limits_bytes_except_current_shard={}, expected_shard_limits_bytes={}]", (Object)shardId.getIndexName(), (Object)shardId.id(), (Object)currentShardLimit, (Object)totalShardLimitsExceptCurrentShard, (Object)newShardLimit);
                return false;
            }
            return true;
        } while (!updateShardLimitPredicate.test(currentShardLimit, newShardLimit));
        logger.debug("Increased Shard Limit [shard_detail=[{}][{}], old_shard_limit_bytes={}, new_shard_limit_bytes={}]", (Object)shardId.getIndexName(), (Object)shardId.id(), (Object)currentShardLimit, (Object)newShardLimit);
        return true;
    }

    private void decreaseShardLimits(ShardId shardId, LongSupplier shardCurrentBytesSupplier, LongSupplier shardLimitSupplier, BiPredicate<Long, Long> updateShardLimitPredicate, long shardBaseLimit) {
        long newShardLimit;
        long currentShardLimit;
        do {
            currentShardLimit = shardLimitSupplier.getAsLong();
            long shardCurrentBytes = shardCurrentBytesSupplier.getAsLong();
            newShardLimit = Math.max((long)((double)shardCurrentBytes / this.optimalOperatingFactor), shardBaseLimit);
            if (!((double)shardCurrentBytes / (double)currentShardLimit > this.lowerOperatingFactor)) continue;
            logger.debug("Shard Limits Already Decreased [shard_detail=[{}][{}], current_shard_limit_bytes={}, expected_shard_limit_bytes={}]", (Object)shardId.getIndexName(), (Object)shardId.id(), (Object)currentShardLimit, (Object)newShardLimit);
            return;
        } while (!updateShardLimitPredicate.test(currentShardLimit, newShardLimit));
        logger.debug("Decreased Shard Limit [shard_detail=[{}][{}], old_shard_limit_bytes={}, new_shard_limit_bytes={}]", (Object)shardId.getIndexName(), (Object)shardId.id(), (Object)currentShardLimit, (Object)newShardLimit);
    }

    private boolean evaluateThroughputDegradationLimitsBreached(ShardIndexingPressureTracker.PerformanceTracker performanceTracker, ShardIndexingPressureTracker.StatsTracker statsTracker, double degradationLimits) {
        double throughputMovingAverage = Double.longBitsToDouble(performanceTracker.getThroughputMovingAverage());
        long throughputMovingQueueSize = performanceTracker.getThroughputMovingQueueSize();
        double throughputHistoricalAverage = (double)statsTracker.getTotalBytes() / (double)performanceTracker.getLatencyInMillis();
        return throughputMovingAverage > 0.0 && throughputMovingQueueSize >= (long)this.shardIndexingPressureSettings.getRequestSizeWindow() && throughputHistoricalAverage / throughputMovingAverage > degradationLimits;
    }

    private boolean evaluateLastSuccessfulRequestDurationLimitsBreached(ShardIndexingPressureTracker.PerformanceTracker performanceTracker, long requestStartTime) {
        return performanceTracker.getLastSuccessfulRequestTimestamp() > 0L && requestStartTime - performanceTracker.getLastSuccessfulRequestTimestamp() > this.successfulRequestElapsedTimeout.nanos() && performanceTracker.getTotalOutstandingRequests() > (long)this.maxOutstandingRequests;
    }

    private void setLowerOperatingFactor(double lowerOperatingFactor) {
        this.lowerOperatingFactor = lowerOperatingFactor;
    }

    private void setOptimalOperatingFactor(double optimalOperatingFactor) {
        this.optimalOperatingFactor = optimalOperatingFactor;
    }

    private void setUpperOperatingFactor(double upperOperatingFactor) {
        this.upperOperatingFactor = upperOperatingFactor;
    }

    private void setSuccessfulRequestElapsedTimeout(TimeValue successfulRequestElapsedTimeout) {
        this.successfulRequestElapsedTimeout = successfulRequestElapsedTimeout;
    }

    private void setMaxOutstandingRequests(int maxOutstandingRequests) {
        this.maxOutstandingRequests = maxOutstandingRequests;
    }

    private void setThroughputDegradationLimits(double throughputDegradationLimits) {
        this.primaryAndCoordinatingThroughputDegradationLimits = throughputDegradationLimits;
        this.replicaThroughputDegradationLimits = this.primaryAndCoordinatingThroughputDegradationLimits * 1.5;
    }

    private void setNodeSoftLimit(double nodeSoftLimit) {
        this.nodeSoftLimit = nodeSoftLimit;
    }

    private void incrementNodeLimitBreachedRejectionCount(ShardIndexingPressureTracker.RejectionTracker rejectionTracker) {
        rejectionTracker.incrementNodeLimitsBreachedRejections();
        this.totalNodeLimitsBreachedRejections.incrementAndGet();
    }
}

