/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.query;

import io.skylite.common.QueryValidationException;
import io.skylite.core.ParseField;
import io.skylite.core.common.ParsingException;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.query.QueryRewriteContext;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.index.query.QueryShardException;
import io.skylite.core.lucene.BytesRefs;
import io.skylite.core.xcontent.AbstractObjectParser;
import io.skylite.core.xcontent.MediaTypeRegistry;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentLocation;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;

public abstract class AbstractQueryBuilder<QB extends AbstractQueryBuilder<QB>>
implements QueryBuilder {
    public static final float DEFAULT_BOOST = 1.0f;
    public static final ParseField BOOST_FIELD = new ParseField("boost", new String[0]);
    protected String queryName;
    protected float boost = 1.0f;

    protected AbstractQueryBuilder() {
    }

    protected AbstractQueryBuilder(StreamInput in) throws IOException {
        this.boost = in.readFloat();
        this.checkNegativeBoost(this.boost);
        this.queryName = in.readOptionalString();
    }

    @Override
    public final void writeTo(StreamOutput out) throws IOException {
        out.writeFloat(this.boost);
        out.writeOptionalString(this.queryName);
        this.doWriteTo(out);
    }

    protected abstract void doWriteTo(StreamOutput var1) throws IOException;

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.doXContent(builder, params);
        builder.endObject();
        return builder;
    }

    protected abstract void doXContent(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    protected void printBoostAndQueryName(XContentBuilder builder) throws IOException {
        builder.field(BOOST_FIELD.getPreferredName(), this.boost);
        if (this.queryName != null) {
            builder.field(ParseField.CommonMetaFields.NAME_FIELD.getPreferredName(), this.queryName);
        }
    }

    @Override
    public final Query toQuery(QueryRewriteContext ctx) throws IOException {
        QueryShardContext context = QueryShardContext.convertFromQueryRewriteContext(ctx);
        Query query = this.doToQuery(context);
        if (query != null) {
            if (this.boost != 1.0f && !(query instanceof MatchNoDocsQuery)) {
                query = new BoostQuery(query, this.boost);
            }
            if (this.queryName != null) {
                context.addNamedQuery(this.queryName, query);
            }
        }
        return query;
    }

    protected abstract Query doToQuery(QueryShardContext var1) throws IOException;

    public final QB queryName(String queryName) {
        this.queryName = queryName;
        return (QB)this;
    }

    @Override
    public final String queryName() {
        return this.queryName;
    }

    @Override
    public final float boost() {
        return this.boost;
    }

    protected final void checkNegativeBoost(float boost) {
        if (Float.compare(boost, 0.0f) < 0) {
            throw new IllegalArgumentException("negative [boost] are not allowed in [" + this.toString() + "], use a value between 0 and 1 to deboost");
        }
    }

    public final QB boost(float boost) {
        this.checkNegativeBoost(boost);
        this.boost = boost;
        return (QB)this;
    }

    protected final QueryValidationException addValidationError(String validationError, QueryValidationException validationException) {
        return QueryValidationException.addValidationError((String)this.getName(), (String)validationError, (QueryValidationException)validationException);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractQueryBuilder other = (AbstractQueryBuilder)obj;
        return Objects.equals(this.queryName, other.queryName) && Objects.equals(Float.valueOf(this.boost), Float.valueOf(other.boost)) && this.doEquals(other);
    }

    protected abstract boolean doEquals(QB var1);

    public final int hashCode() {
        return Objects.hash(this.getClass(), this.queryName, Float.valueOf(this.boost), this.doHashCode());
    }

    protected abstract int doHashCode();

    protected static Object maybeConvertToBytesRef(Object obj) {
        if (obj instanceof String) {
            return BytesRefs.toBytesRef(obj);
        }
        if (obj instanceof CharBuffer) {
            return new BytesRef((CharSequence)((CharBuffer)obj));
        }
        if (obj instanceof BigInteger) {
            return BytesRefs.toBytesRef(obj);
        }
        return obj;
    }

    protected static Object maybeConvertToString(Object obj) {
        if (obj instanceof BytesRef) {
            return ((BytesRef)obj).utf8ToString();
        }
        if (obj instanceof CharBuffer) {
            return new BytesRef((CharSequence)((CharBuffer)obj)).utf8ToString();
        }
        return obj;
    }

    static Collection<Query> toQueries(Collection<QueryBuilder> queryBuilders, QueryShardContext context) throws QueryShardException, IOException {
        ArrayList<Query> queries = new ArrayList<Query>(queryBuilders.size());
        for (QueryBuilder queryBuilder : queryBuilders) {
            Query query = queryBuilder.rewrite(context).toQuery(context);
            if (query == null) continue;
            queries.add(query);
        }
        return queries;
    }

    @Override
    public String getName() {
        return this.getWriteableName();
    }

    static void writeQueries(StreamOutput out, List<? extends QueryBuilder> queries) throws IOException {
        out.writeVInt(queries.size());
        for (QueryBuilder queryBuilder : queries) {
            out.writeNamedWriteable(queryBuilder);
        }
    }

    static List<QueryBuilder> readQueries(StreamInput in) throws IOException {
        int size = in.readVInt();
        ArrayList<QueryBuilder> queries = new ArrayList<QueryBuilder>(size);
        for (int i = 0; i < size; ++i) {
            queries.add(in.readNamedWriteable(QueryBuilder.class));
        }
        return queries;
    }

    @Override
    public final QueryBuilder rewrite(QueryRewriteContext queryShardContext) throws IOException {
        QueryBuilder rewritten = this.doRewrite(queryShardContext);
        if (rewritten == this) {
            return rewritten;
        }
        if (this.queryName() != null && rewritten.queryName() == null) {
            rewritten.queryName(this.queryName());
        }
        if (this.boost() != 1.0f && rewritten.boost() == 1.0f) {
            rewritten.boost(this.boost());
        }
        return rewritten;
    }

    protected QueryBuilder doRewrite(QueryRewriteContext queryShardContext) throws IOException {
        return this;
    }

    public void extractInnerHitBuilders(InnerHitCollector<?> innerHits, InnerHitExtractor extractor) {
    }

    protected static <T> T requireValue(T value, String message) {
        if (value == null) {
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    protected static void throwParsingExceptionOnMultipleFields(String queryName, XContentLocation contentLocation, String processedFieldName, String currentFieldName) {
        if (processedFieldName != null) {
            throw new ParsingException(contentLocation, "[" + queryName + "] query doesn't support multiple fields, found [" + processedFieldName + "] and [" + currentFieldName + "]", new Object[0]);
        }
    }

    protected static void declareStandardFields(AbstractObjectParser<? extends QueryBuilder, ?> parser) {
        parser.declareFloat(QueryBuilder::boost, BOOST_FIELD);
        parser.declareString(QueryBuilder::queryName, ParseField.CommonMetaFields.NAME_FIELD);
    }

    public final String toString() {
        return Strings.toString(MediaTypeRegistry.JSON, this, true, true);
    }

    @FunctionalInterface
    public static interface InnerHitExtractor {
        public void extract(QueryBuilder var1, InnerHitCollector var2);
    }

    public static interface InnerHitCollector<T> {
        public void add(String var1, T var2);

        public Map<String, T> getInnerHitContextBuilder();
    }
}

