/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.query;

import io.skylite.core.ParseField;
import io.skylite.core.common.ParsingException;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.index.query.AbstractQueryBuilder;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.query.QueryBuilderVisitor;
import io.skylite.core.index.query.QueryRewriteContext;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.lucene.search.Queries;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.Query;

public class DisMaxQueryBuilder
extends AbstractQueryBuilder<DisMaxQueryBuilder> {
    public static final String NAME = "dis_max";
    public static final float DEFAULT_TIE_BREAKER = 0.0f;
    private static final ParseField TIE_BREAKER_FIELD = new ParseField("tie_breaker", new String[0]);
    private static final ParseField QUERIES_FIELD = new ParseField("queries", new String[0]);
    private final List<QueryBuilder> queries = new ArrayList<QueryBuilder>();
    private float tieBreaker = 0.0f;

    public DisMaxQueryBuilder() {
    }

    public DisMaxQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.queries.addAll(DisMaxQueryBuilder.readQueries(in));
        this.tieBreaker = in.readFloat();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        DisMaxQueryBuilder.writeQueries(out, this.queries);
        out.writeFloat(this.tieBreaker);
    }

    public DisMaxQueryBuilder add(QueryBuilder queryBuilder) {
        if (queryBuilder == null) {
            throw new IllegalArgumentException("inner dismax query clause cannot be null");
        }
        this.queries.add(queryBuilder);
        return this;
    }

    public List<QueryBuilder> innerQueries() {
        return this.queries;
    }

    public DisMaxQueryBuilder tieBreaker(float tieBreaker) {
        this.tieBreaker = tieBreaker;
        return this;
    }

    public float tieBreaker() {
        return this.tieBreaker;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(TIE_BREAKER_FIELD.getPreferredName(), this.tieBreaker);
        builder.startArray(QUERIES_FIELD.getPreferredName());
        for (QueryBuilder queryBuilder : this.queries) {
            queryBuilder.toXContent(builder, params);
        }
        builder.endArray();
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static DisMaxQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        float boost = 1.0f;
        float tieBreaker = 0.0f;
        ArrayList<QueryBuilder> queries = new ArrayList<QueryBuilder>();
        boolean queriesFound = false;
        String queryName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (QUERIES_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    queriesFound = true;
                    queries.add(QueryBuilder.parseInnerQueryBuilder(parser));
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[dis_max] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (QUERIES_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    queriesFound = true;
                    while (token != XContentParser.Token.END_ARRAY) {
                        queries.add(QueryBuilder.parseInnerQueryBuilder(parser));
                        token = parser.nextToken();
                    }
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[dis_max] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                boost = parser.floatValue();
                continue;
            }
            if (TIE_BREAKER_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                tieBreaker = parser.floatValue();
                continue;
            }
            if (ParseField.CommonMetaFields.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                queryName = parser.text();
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "[dis_max] query does not support [" + currentFieldName + "]", new Object[0]);
        }
        if (!queriesFound) {
            throw new ParsingException(parser.getTokenLocation(), "[dis_max] requires 'queries' field with at least one clause", new Object[0]);
        }
        DisMaxQueryBuilder disMaxQuery = new DisMaxQueryBuilder();
        disMaxQuery.tieBreaker(tieBreaker);
        disMaxQuery.queryName(queryName);
        disMaxQuery.boost(boost);
        for (QueryBuilder query : queries) {
            disMaxQuery.add(query);
        }
        return disMaxQuery;
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        Collection<Query> luceneQueries = DisMaxQueryBuilder.toQueries(this.queries, context);
        if (luceneQueries.isEmpty()) {
            return Queries.newMatchNoDocsQuery("no clauses for dismax query.");
        }
        return new DisjunctionMaxQuery(luceneQueries, this.tieBreaker);
    }

    @Override
    protected QueryBuilder doRewrite(QueryRewriteContext queryShardContext) throws IOException {
        DisMaxQueryBuilder newBuilder = new DisMaxQueryBuilder();
        boolean changed = false;
        for (QueryBuilder query : this.queries) {
            QueryBuilder result = query.rewrite(queryShardContext);
            if (result != query) {
                changed = true;
            }
            newBuilder.add(result);
        }
        if (changed) {
            newBuilder.queryName(this.queryName);
            newBuilder.boost(this.boost);
            newBuilder.tieBreaker(this.tieBreaker);
            return newBuilder;
        }
        return this;
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.queries, Float.valueOf(this.tieBreaker));
    }

    @Override
    protected boolean doEquals(DisMaxQueryBuilder other) {
        return Objects.equals(this.queries, other.queries) && Objects.equals(Float.valueOf(this.tieBreaker), Float.valueOf(other.tieBreaker));
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public void extractInnerHitBuilders(AbstractQueryBuilder.InnerHitCollector<?> innerHits, AbstractQueryBuilder.InnerHitExtractor extractor) {
        for (QueryBuilder query : this.queries) {
            extractor.extract(query, innerHits);
        }
    }

    @Override
    public void visit(QueryBuilderVisitor visitor) {
        visitor.accept(this);
        if (!this.queries.isEmpty()) {
            QueryBuilderVisitor subVisitor = visitor.getChildVisitor(BooleanClause.Occur.SHOULD);
            for (QueryBuilder subQb : this.queries) {
                subVisitor.accept(subQb);
            }
        }
    }
}

