/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.query;

import io.skylite.core.ParseField;
import io.skylite.core.common.ParsingException;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.index.query.AbstractQueryBuilder;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.query.QueryBuilderVisitor;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.index.query.SpanQueryBuilder;
import io.skylite.core.mapper.MappedFieldType;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.queries.spans.FieldMaskingSpanQuery;
import org.apache.lucene.queries.spans.SpanQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Query;

public class FieldMaskingSpanQueryBuilder
extends AbstractQueryBuilder<FieldMaskingSpanQueryBuilder>
implements SpanQueryBuilder {
    public static final ParseField SPAN_FIELD_MASKING_FIELD = new ParseField("span_field_masking", "field_masking_span");
    private static final ParseField FIELD_FIELD = new ParseField("field", new String[0]);
    private static final ParseField QUERY_FIELD = new ParseField("query", new String[0]);
    private final SpanQueryBuilder queryBuilder;
    private final String fieldName;

    public FieldMaskingSpanQueryBuilder(SpanQueryBuilder queryBuilder, String fieldName) {
        if (Strings.isEmpty(fieldName)) {
            throw new IllegalArgumentException("field name is null or empty");
        }
        if (queryBuilder == null) {
            throw new IllegalArgumentException("inner clause [query] cannot be null.");
        }
        this.queryBuilder = queryBuilder;
        this.fieldName = fieldName;
    }

    public FieldMaskingSpanQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.queryBuilder = (SpanQueryBuilder)in.readNamedWriteable(QueryBuilder.class);
        this.fieldName = in.readString();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.queryBuilder);
        out.writeString(this.fieldName);
    }

    public String fieldName() {
        return this.fieldName;
    }

    public SpanQueryBuilder innerQuery() {
        return this.queryBuilder;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(SPAN_FIELD_MASKING_FIELD.getPreferredName());
        builder.field(QUERY_FIELD.getPreferredName());
        this.queryBuilder.toXContent(builder, params);
        builder.field(FIELD_FIELD.getPreferredName(), this.fieldName);
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static FieldMaskingSpanQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        float boost = 1.0f;
        SpanQueryBuilder inner = null;
        String field = null;
        String queryName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (QUERY_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    QueryBuilder query = QueryBuilder.parseInnerQueryBuilder(parser);
                    if (!(query instanceof SpanQueryBuilder)) {
                        throw new ParsingException(parser.getTokenLocation(), "[" + SPAN_FIELD_MASKING_FIELD.getPreferredName() + "] query must be of type span query", new Object[0]);
                    }
                    inner = (SpanQueryBuilder)query;
                    SpanQueryBuilder.SpanQueryBuilderUtil.checkNoBoost(SPAN_FIELD_MASKING_FIELD.getPreferredName(), currentFieldName, parser, inner);
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[" + SPAN_FIELD_MASKING_FIELD.getPreferredName() + "] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                boost = parser.floatValue();
                continue;
            }
            if (FIELD_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                field = parser.text();
                continue;
            }
            if (ParseField.CommonMetaFields.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                queryName = parser.text();
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "[" + SPAN_FIELD_MASKING_FIELD.getPreferredName() + "] query does not support [" + currentFieldName + "]", new Object[0]);
        }
        if (inner == null) {
            throw new ParsingException(parser.getTokenLocation(), SPAN_FIELD_MASKING_FIELD.getPreferredName() + " must have [query] span query clause", new Object[0]);
        }
        if (field == null) {
            throw new ParsingException(parser.getTokenLocation(), SPAN_FIELD_MASKING_FIELD.getPreferredName() + " must have [field] set for it", new Object[0]);
        }
        FieldMaskingSpanQueryBuilder queryBuilder = new FieldMaskingSpanQueryBuilder(inner, field);
        queryBuilder.boost(boost);
        queryBuilder.queryName(queryName);
        return queryBuilder;
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        String fieldInQuery = this.fieldName;
        MappedFieldType fieldType = context.getFieldType(this.fieldName);
        if (fieldType != null) {
            fieldInQuery = fieldType.name();
        }
        Query innerQuery = this.queryBuilder.toQuery(context);
        assert (innerQuery instanceof SpanQuery);
        return new FieldMaskingSpanQuery((SpanQuery)innerQuery, fieldInQuery);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.queryBuilder, this.fieldName);
    }

    @Override
    protected boolean doEquals(FieldMaskingSpanQueryBuilder other) {
        return Objects.equals(this.queryBuilder, other.queryBuilder) && Objects.equals(this.fieldName, other.fieldName);
    }

    @Override
    public String getWriteableName() {
        return SPAN_FIELD_MASKING_FIELD.getPreferredName();
    }

    @Override
    public void visit(QueryBuilderVisitor visitor) {
        visitor.accept(this);
        visitor.getChildVisitor(BooleanClause.Occur.MUST).accept(this.queryBuilder);
    }
}

