/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.query;

import io.skylite.SkyliteException;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import java.io.IOException;

public enum IntervalMode implements Writeable
{
    ORDERED(0),
    UNORDERED(1),
    UNORDERED_NO_OVERLAP(2);

    private final int ordinal;

    private IntervalMode(int ordinal) {
        this.ordinal = ordinal;
    }

    public static IntervalMode readFromStream(StreamInput in) throws IOException {
        int ord = in.readVInt();
        switch (ord) {
            case 0: {
                return ORDERED;
            }
            case 1: {
                return UNORDERED;
            }
            case 2: {
                return UNORDERED_NO_OVERLAP;
            }
        }
        throw new SkyliteException("unknown serialized type [" + ord + "]", new Object[0]);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.ordinal);
    }

    public static IntervalMode fromString(String intervalMode) {
        if (intervalMode == null) {
            throw new IllegalArgumentException("cannot parse mode from null string");
        }
        for (IntervalMode mode : IntervalMode.values()) {
            if (!mode.name().equalsIgnoreCase(intervalMode)) continue;
            return mode;
        }
        throw new IllegalArgumentException("no mode can be parsed from ordinal " + intervalMode);
    }
}

