/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.query;

import io.skylite.OpenSearchVersion;
import io.skylite.core.ParseField;
import io.skylite.core.common.ParsingException;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.unit.Fuzziness;
import io.skylite.core.index.query.AbstractQueryBuilder;
import io.skylite.core.index.query.Operator;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.index.query.QueryShardException;
import io.skylite.core.index.query.support.MatchQuery;
import io.skylite.core.index.query.support.QueryParsers;
import io.skylite.core.lucene.search.Queries;
import io.skylite.core.xcontent.LoggingDeprecationHandler;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.search.Query;

public class MatchQueryBuilder
extends AbstractQueryBuilder<MatchQueryBuilder> {
    public static final ParseField ZERO_TERMS_QUERY_FIELD = new ParseField("zero_terms_query", new String[0]);
    public static final ParseField LENIENT_FIELD = new ParseField("lenient", new String[0]);
    public static final ParseField FUZZY_TRANSPOSITIONS_FIELD = new ParseField("fuzzy_transpositions", new String[0]);
    public static final ParseField FUZZY_REWRITE_FIELD = new ParseField("fuzzy_rewrite", new String[0]);
    public static final ParseField MINIMUM_SHOULD_MATCH_FIELD = new ParseField("minimum_should_match", new String[0]);
    public static final ParseField OPERATOR_FIELD = new ParseField("operator", new String[0]);
    public static final ParseField MAX_EXPANSIONS_FIELD = new ParseField("max_expansions", new String[0]);
    public static final ParseField PREFIX_LENGTH_FIELD = new ParseField("prefix_length", new String[0]);
    public static final ParseField ANALYZER_FIELD = new ParseField("analyzer", new String[0]);
    public static final ParseField QUERY_FIELD = new ParseField("query", new String[0]);
    public static final ParseField GENERATE_SYNONYMS_PHRASE_QUERY = new ParseField("auto_generate_synonyms_phrase_query", new String[0]);
    public static final String NAME = "match";
    public static final Operator DEFAULT_OPERATOR = Operator.OR;
    private final String fieldName;
    private final Object value;
    private Operator operator = DEFAULT_OPERATOR;
    private String analyzer;
    private Fuzziness fuzziness = null;
    private int prefixLength = 0;
    private int maxExpansions = 50;
    private boolean fuzzyTranspositions = true;
    private String minimumShouldMatch;
    private String fuzzyRewrite = null;
    private boolean lenient = false;
    private MatchQuery.ZeroTermsQuery zeroTermsQuery = MatchQuery.DEFAULT_ZERO_TERMS_QUERY;
    private boolean autoGenerateSynonymsPhraseQuery = true;

    public MatchQueryBuilder(String fieldName, Object value) {
        if (fieldName == null) {
            throw new IllegalArgumentException("[match] requires fieldName");
        }
        if (value == null) {
            throw new IllegalArgumentException("[match] requires query value");
        }
        this.fieldName = fieldName;
        this.value = value;
    }

    public MatchQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.fieldName = in.readString();
        this.value = in.readGenericValue();
        this.operator = Operator.readFromStream(in);
        this.prefixLength = in.readVInt();
        this.maxExpansions = in.readVInt();
        this.fuzzyTranspositions = in.readBoolean();
        this.lenient = in.readBoolean();
        this.zeroTermsQuery = MatchQuery.ZeroTermsQuery.readFromStream(in);
        this.analyzer = in.readOptionalString();
        this.minimumShouldMatch = in.readOptionalString();
        this.fuzzyRewrite = in.readOptionalString();
        this.fuzziness = in.readOptionalWriteable(Fuzziness::new);
        if (in.getVersion().before(OpenSearchVersion.V_3_0_0)) {
            in.readOptionalFloat();
        }
        this.autoGenerateSynonymsPhraseQuery = in.readBoolean();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
        out.writeGenericValue(this.value);
        this.operator.writeTo(out);
        out.writeVInt(this.prefixLength);
        out.writeVInt(this.maxExpansions);
        out.writeBoolean(this.fuzzyTranspositions);
        out.writeBoolean(this.lenient);
        this.zeroTermsQuery.writeTo(out);
        out.writeOptionalString(this.analyzer);
        out.writeOptionalString(this.minimumShouldMatch);
        out.writeOptionalString(this.fuzzyRewrite);
        out.writeOptionalWriteable(this.fuzziness);
        if (out.getVersion().before(OpenSearchVersion.V_3_0_0)) {
            out.writeOptionalFloat(null);
        }
        out.writeBoolean(this.autoGenerateSynonymsPhraseQuery);
    }

    public String fieldName() {
        return this.fieldName;
    }

    public Object value() {
        return this.value;
    }

    public MatchQueryBuilder operator(Operator operator) {
        if (operator == null) {
            throw new IllegalArgumentException("[match] requires operator to be non-null");
        }
        this.operator = operator;
        return this;
    }

    public Operator operator() {
        return this.operator;
    }

    public MatchQueryBuilder analyzer(String analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    public String analyzer() {
        return this.analyzer;
    }

    public MatchQueryBuilder fuzziness(Fuzziness fuzziness) {
        this.fuzziness = Objects.requireNonNull(fuzziness);
        return this;
    }

    public Fuzziness fuzziness() {
        return this.fuzziness;
    }

    public MatchQueryBuilder prefixLength(int prefixLength) {
        if (prefixLength < 0) {
            throw new IllegalArgumentException("[match] requires prefix length to be non-negative.");
        }
        this.prefixLength = prefixLength;
        return this;
    }

    public int prefixLength() {
        return this.prefixLength;
    }

    public MatchQueryBuilder maxExpansions(int maxExpansions) {
        if (maxExpansions <= 0) {
            throw new IllegalArgumentException("[match] requires maxExpansions to be positive.");
        }
        this.maxExpansions = maxExpansions;
        return this;
    }

    public int maxExpansions() {
        return this.maxExpansions;
    }

    public MatchQueryBuilder minimumShouldMatch(String minimumShouldMatch) {
        this.minimumShouldMatch = minimumShouldMatch;
        return this;
    }

    public String minimumShouldMatch() {
        return this.minimumShouldMatch;
    }

    public MatchQueryBuilder fuzzyRewrite(String fuzzyRewrite) {
        this.fuzzyRewrite = fuzzyRewrite;
        return this;
    }

    public String fuzzyRewrite() {
        return this.fuzzyRewrite;
    }

    public MatchQueryBuilder fuzzyTranspositions(boolean fuzzyTranspositions) {
        this.fuzzyTranspositions = fuzzyTranspositions;
        return this;
    }

    public boolean fuzzyTranspositions() {
        return this.fuzzyTranspositions;
    }

    public MatchQueryBuilder lenient(boolean lenient) {
        this.lenient = lenient;
        return this;
    }

    public boolean lenient() {
        return this.lenient;
    }

    public MatchQueryBuilder zeroTermsQuery(MatchQuery.ZeroTermsQuery zeroTermsQuery) {
        if (zeroTermsQuery == null) {
            throw new IllegalArgumentException("[match] requires zeroTermsQuery to be non-null");
        }
        this.zeroTermsQuery = zeroTermsQuery;
        return this;
    }

    public MatchQuery.ZeroTermsQuery zeroTermsQuery() {
        return this.zeroTermsQuery;
    }

    public MatchQueryBuilder autoGenerateSynonymsPhraseQuery(boolean enable) {
        this.autoGenerateSynonymsPhraseQuery = enable;
        return this;
    }

    public boolean autoGenerateSynonymsPhraseQuery() {
        return this.autoGenerateSynonymsPhraseQuery;
    }

    @Override
    public void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.startObject(this.fieldName);
        builder.field(QUERY_FIELD.getPreferredName(), this.value);
        builder.field(OPERATOR_FIELD.getPreferredName(), this.operator.toString());
        if (this.analyzer != null) {
            builder.field(ANALYZER_FIELD.getPreferredName(), this.analyzer);
        }
        if (this.fuzziness != null) {
            this.fuzziness.toXContent(builder, params);
        }
        builder.field(PREFIX_LENGTH_FIELD.getPreferredName(), this.prefixLength);
        builder.field(MAX_EXPANSIONS_FIELD.getPreferredName(), this.maxExpansions);
        if (this.minimumShouldMatch != null) {
            builder.field(MINIMUM_SHOULD_MATCH_FIELD.getPreferredName(), this.minimumShouldMatch);
        }
        if (this.fuzzyRewrite != null) {
            builder.field(FUZZY_REWRITE_FIELD.getPreferredName(), this.fuzzyRewrite);
        }
        builder.field(FUZZY_TRANSPOSITIONS_FIELD.getPreferredName(), this.fuzzyTranspositions);
        builder.field(LENIENT_FIELD.getPreferredName(), this.lenient);
        builder.field(ZERO_TERMS_QUERY_FIELD.getPreferredName(), this.zeroTermsQuery.toString());
        builder.field(GENERATE_SYNONYMS_PHRASE_QUERY.getPreferredName(), this.autoGenerateSynonymsPhraseQuery);
        this.printBoostAndQueryName(builder);
        builder.endObject();
        builder.endObject();
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        if (this.analyzer != null && context.getIndexAnalyzers().get(this.analyzer) == null) {
            throw new QueryShardException(context.getFullyQualifiedIndex(), "[match] analyzer [" + this.analyzer + "] not found", new Object[0]);
        }
        MatchQuery matchQuery = new MatchQuery(context);
        matchQuery.setOccur(this.operator.toBooleanClauseOccur());
        if (this.analyzer != null) {
            matchQuery.setAnalyzer(this.analyzer);
        }
        matchQuery.setFuzziness(this.fuzziness);
        matchQuery.setFuzzyPrefixLength(this.prefixLength);
        matchQuery.setMaxExpansions(this.maxExpansions);
        matchQuery.setTranspositions(this.fuzzyTranspositions);
        matchQuery.setFuzzyRewriteMethod(QueryParsers.parseRewriteMethod(this.fuzzyRewrite, null, LoggingDeprecationHandler.INSTANCE));
        matchQuery.setLenient(this.lenient);
        matchQuery.setZeroTermsQuery(this.zeroTermsQuery);
        matchQuery.setAutoGenerateSynonymsPhraseQuery(this.autoGenerateSynonymsPhraseQuery);
        Query query = matchQuery.parse(MatchQuery.Type.BOOLEAN, this.fieldName, this.value);
        return Queries.maybeApplyMinimumShouldMatch(query, this.minimumShouldMatch);
    }

    @Override
    protected boolean doEquals(MatchQueryBuilder other) {
        return Objects.equals(this.fieldName, other.fieldName) && Objects.equals(this.value, other.value) && Objects.equals(this.operator, other.operator) && Objects.equals(this.analyzer, other.analyzer) && Objects.equals(this.fuzziness, other.fuzziness) && Objects.equals(this.prefixLength, other.prefixLength) && Objects.equals(this.maxExpansions, other.maxExpansions) && Objects.equals(this.minimumShouldMatch, other.minimumShouldMatch) && Objects.equals(this.fuzzyRewrite, other.fuzzyRewrite) && Objects.equals(this.lenient, other.lenient) && Objects.equals(this.fuzzyTranspositions, other.fuzzyTranspositions) && Objects.equals(this.zeroTermsQuery, other.zeroTermsQuery) && Objects.equals(this.autoGenerateSynonymsPhraseQuery, other.autoGenerateSynonymsPhraseQuery);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.fieldName, this.value, this.operator, this.analyzer, this.fuzziness, this.prefixLength, this.maxExpansions, this.minimumShouldMatch, this.fuzzyRewrite, this.lenient, this.fuzzyTranspositions, this.zeroTermsQuery, this.autoGenerateSynonymsPhraseQuery);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    public static MatchQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        Object value = null;
        float boost = 1.0f;
        String minimumShouldMatch = null;
        String analyzer = null;
        Operator operator = DEFAULT_OPERATOR;
        Fuzziness fuzziness = null;
        int prefixLength = 0;
        int maxExpansion = 50;
        boolean fuzzyTranspositions = true;
        String fuzzyRewrite = null;
        boolean lenient = false;
        MatchQuery.ZeroTermsQuery zeroTermsQuery = MatchQuery.DEFAULT_ZERO_TERMS_QUERY;
        boolean autoGenerateSynonymsPhraseQuery = true;
        String queryName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                MatchQueryBuilder.throwParsingExceptionOnMultipleFields(NAME, parser.getTokenLocation(), fieldName, currentFieldName);
                fieldName = currentFieldName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if (token.isValue()) {
                        if (QUERY_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                            value = parser.objectText();
                            continue;
                        }
                        if (ANALYZER_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                            analyzer = parser.text();
                            continue;
                        }
                        if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                            boost = parser.floatValue();
                            continue;
                        }
                        if (Fuzziness.FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                            fuzziness = Fuzziness.parse(parser);
                            continue;
                        }
                        if (PREFIX_LENGTH_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                            prefixLength = parser.intValue();
                            continue;
                        }
                        if (MAX_EXPANSIONS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                            maxExpansion = parser.intValue();
                            continue;
                        }
                        if (OPERATOR_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                            operator = Operator.fromString(parser.text());
                            continue;
                        }
                        if (MINIMUM_SHOULD_MATCH_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                            minimumShouldMatch = parser.textOrNull();
                            continue;
                        }
                        if (FUZZY_REWRITE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                            fuzzyRewrite = parser.textOrNull();
                            continue;
                        }
                        if (FUZZY_TRANSPOSITIONS_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                            fuzzyTranspositions = parser.booleanValue();
                            continue;
                        }
                        if (LENIENT_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                            lenient = parser.booleanValue();
                            continue;
                        }
                        if (ZERO_TERMS_QUERY_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                            String zeroTermsValue = parser.text();
                            if ("none".equalsIgnoreCase(zeroTermsValue)) {
                                zeroTermsQuery = MatchQuery.ZeroTermsQuery.NONE;
                                continue;
                            }
                            if ("all".equalsIgnoreCase(zeroTermsValue)) {
                                zeroTermsQuery = MatchQuery.ZeroTermsQuery.ALL;
                                continue;
                            }
                            throw new ParsingException(parser.getTokenLocation(), "Unsupported zero_terms_query value [" + zeroTermsValue + "]", new Object[0]);
                        }
                        if (ParseField.CommonMetaFields.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                            queryName = parser.text();
                            continue;
                        }
                        if (GENERATE_SYNONYMS_PHRASE_QUERY.match(currentFieldName, parser.getDeprecationHandler())) {
                            autoGenerateSynonymsPhraseQuery = parser.booleanValue();
                            continue;
                        }
                        throw new ParsingException(parser.getTokenLocation(), "[match] query does not support [" + currentFieldName + "]", new Object[0]);
                    }
                    throw new ParsingException(parser.getTokenLocation(), "[match] unknown token [" + String.valueOf((Object)token) + "] after [" + currentFieldName + "]", new Object[0]);
                }
                continue;
            }
            MatchQueryBuilder.throwParsingExceptionOnMultipleFields(NAME, parser.getTokenLocation(), fieldName, parser.currentName());
            fieldName = parser.currentName();
            value = parser.objectText();
        }
        if (value == null) {
            throw new ParsingException(parser.getTokenLocation(), "No text specified for text query", new Object[0]);
        }
        MatchQueryBuilder matchQuery = new MatchQueryBuilder(fieldName, value);
        matchQuery.operator(operator);
        matchQuery.analyzer(analyzer);
        matchQuery.minimumShouldMatch(minimumShouldMatch);
        if (fuzziness != null) {
            matchQuery.fuzziness(fuzziness);
        }
        matchQuery.fuzzyRewrite(fuzzyRewrite);
        matchQuery.prefixLength(prefixLength);
        matchQuery.fuzzyTranspositions(fuzzyTranspositions);
        matchQuery.maxExpansions(maxExpansion);
        matchQuery.lenient(lenient);
        matchQuery.zeroTermsQuery(zeroTermsQuery);
        matchQuery.autoGenerateSynonymsPhraseQuery(autoGenerateSynonymsPhraseQuery);
        matchQuery.queryName(queryName);
        matchQuery.boost(boost);
        return matchQuery;
    }
}

