/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.query;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.common.util.CollectionUtils;
import java.io.IOException;
import java.util.Locale;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;

public enum Operator implements Writeable
{
    OR,
    AND;


    public BooleanClause.Occur toBooleanClauseOccur() {
        switch (this.ordinal()) {
            case 0: {
                return BooleanClause.Occur.SHOULD;
            }
            case 1: {
                return BooleanClause.Occur.MUST;
            }
        }
        throw Operator.newOperatorException(this.toString());
    }

    public QueryParser.Operator toQueryParserOperator() {
        switch (this.ordinal()) {
            case 0: {
                return QueryParser.Operator.OR;
            }
            case 1: {
                return QueryParser.Operator.AND;
            }
        }
        throw Operator.newOperatorException(this.toString());
    }

    public static Operator readFromStream(StreamInput in) throws IOException {
        return in.readEnum(Operator.class);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum(this);
    }

    public static Operator fromString(String op) {
        return Operator.valueOf(op.toUpperCase(Locale.ROOT));
    }

    private static IllegalArgumentException newOperatorException(String op) {
        return new IllegalArgumentException("operator needs to be either " + String.valueOf(CollectionUtils.arrayAsArrayList(Operator.values())) + ", but not [" + op + "]");
    }
}

