/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.query;

import io.skylite.core.common.ParsingException;
import io.skylite.core.common.io.stream.NamedWriteable;
import io.skylite.core.index.query.CheckedQueryBuilderVisitor;
import io.skylite.core.index.query.QueryBuilderVisitor;
import io.skylite.core.index.query.QueryRewriteContext;
import io.skylite.core.index.query.Rewriteable;
import io.skylite.core.search.sort.NestedSortBuilder;
import io.skylite.core.xcontent.NamedObjectNotFoundException;
import io.skylite.core.xcontent.SuggestingErrorOnUnknown;
import io.skylite.core.xcontent.ToXContentObject;
import io.skylite.core.xcontent.XContentLocation;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Locale;
import org.apache.lucene.search.Query;

public interface QueryBuilder
extends NamedWriteable,
ToXContentObject,
Rewriteable<QueryBuilder> {
    public Query toQuery(QueryRewriteContext var1) throws IOException;

    public QueryBuilder queryName(String var1);

    public String queryName();

    public float boost();

    public QueryBuilder boost(float var1);

    public String getName();

    @Override
    default public QueryBuilder rewrite(QueryRewriteContext queryRewriteContext) throws IOException {
        return this;
    }

    default public void visit(QueryBuilderVisitor visitor) {
        visitor.accept(this);
    }

    default public <V extends CheckedQueryBuilderVisitor<V, R, E>, R, E extends Exception> R visit(V visitor) throws E {
        return visitor.accept(this);
    }

    public static QueryBuilder parseInnerQueryBuilder(XContentParser parser) throws IOException {
        QueryBuilder result;
        if (parser.currentToken() != XContentParser.Token.START_OBJECT && parser.nextToken() != XContentParser.Token.START_OBJECT) {
            throw new ParsingException(parser.getTokenLocation(), "[_na] query malformed, must start with start_object", new Object[0]);
        }
        if (parser.nextToken() == XContentParser.Token.END_OBJECT) {
            throw new IllegalArgumentException("query malformed, empty clause found at [" + String.valueOf(parser.getTokenLocation()) + "]");
        }
        if (parser.currentToken() != XContentParser.Token.FIELD_NAME) {
            throw new ParsingException(parser.getTokenLocation(), "[_na] query malformed, no field after start_object", new Object[0]);
        }
        String queryName = parser.currentName();
        if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
            throw new ParsingException(parser.getTokenLocation(), "[" + queryName + "] query malformed, no start_object after query name", new Object[0]);
        }
        try {
            result = parser.namedObject(QueryBuilder.class, queryName, null);
        }
        catch (NamedObjectNotFoundException e) {
            String message = String.format(Locale.ROOT, "unknown query [%s]%s", queryName, SuggestingErrorOnUnknown.suggest(queryName, e.getCandidates()));
            throw new ParsingException(new XContentLocation(e.getLineNumber(), e.getColumnNumber()), message, e, new Object[0]);
        }
        if (parser.currentToken() != XContentParser.Token.END_OBJECT) {
            throw new ParsingException(parser.getTokenLocation(), "[" + queryName + "] malformed query, expected [END_OBJECT] but found [" + String.valueOf((Object)parser.currentToken()) + "]", new Object[0]);
        }
        if (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            throw new ParsingException(parser.getTokenLocation(), "[" + queryName + "] malformed query, expected [END_OBJECT] but found [" + String.valueOf((Object)parser.currentToken()) + "]", new Object[0]);
        }
        return result;
    }

    public static QueryBuilder parseNestedFilter(XContentParser parser) {
        try {
            return QueryBuilder.parseInnerQueryBuilder(parser);
        }
        catch (Exception e) {
            throw new ParsingException(parser.getTokenLocation(), "Expected " + NestedSortBuilder.NESTED_FILTER_FIELD.getPreferredName() + " element.", e, new Object[0]);
        }
    }
}

