/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.query;

import io.skylite.core.ParseField;
import io.skylite.core.common.ParsingException;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.index.query.AbstractQueryBuilder;
import io.skylite.core.index.query.BaseTermQueryBuilder;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.index.query.SpanQueryBuilder;
import io.skylite.core.lucene.queries.SpanMatchNoDocsQuery;
import io.skylite.core.mapper.MappedFieldType;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.spans.SpanQuery;
import org.apache.lucene.queries.spans.SpanTermQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;

public class SpanTermQueryBuilder
extends BaseTermQueryBuilder<SpanTermQueryBuilder>
implements SpanQueryBuilder {
    public static final String NAME = "span_term";
    private static final ParseField TERM_FIELD = new ParseField("term", new String[0]);

    public SpanTermQueryBuilder(String name, String value) {
        super(name, (Object)value);
    }

    public SpanTermQueryBuilder(String name, int value) {
        super(name, (Object)value);
    }

    public SpanTermQueryBuilder(String name, long value) {
        super(name, (Object)value);
    }

    public SpanTermQueryBuilder(String name, float value) {
        super(name, Float.valueOf(value));
    }

    public SpanTermQueryBuilder(String name, double value) {
        super(name, (Object)value);
    }

    public SpanTermQueryBuilder(String name, Object value) {
        super(name, value);
    }

    public SpanTermQueryBuilder(StreamInput in) throws IOException {
        super(in);
    }

    protected SpanQuery doToQuery(QueryShardContext context) throws IOException {
        MappedFieldType mapper = context.getFieldType(this.fieldName);
        if (mapper == null) {
            return new SpanMatchNoDocsQuery(this.fieldName, "unmapped field: " + this.fieldName);
        }
        if (!mapper.getTextSearchInfo().hasPositions()) {
            throw new IllegalArgumentException("Span term query requires position data, but field " + this.fieldName + " was indexed without position data");
        }
        Query termQuery = mapper.termQuery(this.value, context);
        final ArrayList termsList = new ArrayList();
        termQuery.visit(new QueryVisitor(this){

            public QueryVisitor getSubVisitor(BooleanClause.Occur occur, Query parent) {
                if (occur == BooleanClause.Occur.MUST || occur == BooleanClause.Occur.FILTER) {
                    return this;
                }
                return EMPTY_VISITOR;
            }

            public void consumeTerms(Query query, Term ... terms) {
                termsList.addAll(Arrays.asList(terms));
            }
        });
        if (termsList.size() != 1) {
            throw new IllegalArgumentException("Cannot extract a term from a query of type " + String.valueOf(termQuery.getClass()) + ": " + String.valueOf(termQuery));
        }
        return new SpanTermQuery((Term)termsList.get(0));
    }

    public static SpanTermQueryBuilder fromXContent(XContentParser parser) throws IOException, ParsingException {
        XContentParser.Token token;
        String fieldName = null;
        Object value = null;
        float boost = 1.0f;
        String queryName = null;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                SpanTermQueryBuilder.throwParsingExceptionOnMultipleFields(NAME, parser.getTokenLocation(), fieldName, currentFieldName);
                fieldName = currentFieldName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if (TERM_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        value = SpanTermQueryBuilder.maybeConvertToBytesRef(parser.objectBytes());
                        continue;
                    }
                    if (BaseTermQueryBuilder.VALUE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        value = SpanTermQueryBuilder.maybeConvertToBytesRef(parser.objectBytes());
                        continue;
                    }
                    if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        boost = parser.floatValue();
                        continue;
                    }
                    if (ParseField.CommonMetaFields.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        queryName = parser.text();
                        continue;
                    }
                    throw new ParsingException(parser.getTokenLocation(), "[span_term] query does not support [" + currentFieldName + "]", new Object[0]);
                }
                continue;
            }
            SpanTermQueryBuilder.throwParsingExceptionOnMultipleFields(NAME, parser.getTokenLocation(), fieldName, parser.currentName());
            fieldName = parser.currentName();
            value = SpanTermQueryBuilder.maybeConvertToBytesRef(parser.objectBytes());
        }
        SpanTermQueryBuilder result = new SpanTermQueryBuilder(fieldName, value);
        ((SpanTermQueryBuilder)result.boost(boost)).queryName(queryName);
        return result;
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }
}

