/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.remote.filecache;

import io.skylite.common.cache.CacheUsage;
import io.skylite.common.cache.RefCountedCache;
import io.skylite.common.cache.SegmentedCache;
import io.skylite.common.cache.stats.CacheStats;
import io.skylite.core.common.breaker.CircuitBreaker;
import io.skylite.core.common.breaker.CircuitBreakingException;
import io.skylite.core.index.remote.filecache.CachedIndexInput;
import io.skylite.core.index.remote.filecache.FileCacheStats;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.spi.SettingsProvider;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.apache.lucene.store.IndexInput;

public class FileCache
implements RefCountedCache<Path, CachedIndexInput> {
    private final SegmentedCache<Path, CachedIndexInput> theCache;
    private final CircuitBreaker circuitBreaker;
    public static final Setting<Double> DATA_TO_FILE_CACHE_SIZE_RATIO_SETTING = Setting.doubleSetting("cluster.filecache.remote_data_ratio", 0.0, 0.0, Setting.Property.NodeScope, Setting.Property.Dynamic);

    public FileCache(SegmentedCache<Path, CachedIndexInput> cache, CircuitBreaker circuitBreaker) {
        this.theCache = cache;
        this.circuitBreaker = circuitBreaker;
    }

    public long capacity() {
        return this.theCache.capacity();
    }

    public CachedIndexInput put(Path filePath, CachedIndexInput indexInput) {
        CachedIndexInput cachedIndexInput = (CachedIndexInput)this.theCache.put((Object)filePath, (Object)indexInput);
        this.checkParentBreaker(filePath);
        return cachedIndexInput;
    }

    public CachedIndexInput compute(Path key, BiFunction<? super Path, ? super CachedIndexInput, ? extends CachedIndexInput> remappingFunction) {
        CachedIndexInput cachedIndexInput = (CachedIndexInput)this.theCache.compute((Object)key, remappingFunction);
        this.checkParentBreaker(key);
        return cachedIndexInput;
    }

    public CachedIndexInput get(Path filePath) {
        return (CachedIndexInput)this.theCache.get((Object)filePath);
    }

    public void remove(Path filePath) {
        this.theCache.remove((Object)filePath);
    }

    public void clear() {
        this.theCache.clear();
    }

    public long size() {
        return this.theCache.size();
    }

    public void incRef(Path key) {
        this.theCache.incRef((Object)key);
    }

    public void decRef(Path key) {
        this.theCache.decRef((Object)key);
    }

    public long prune() {
        return this.theCache.prune();
    }

    public long prune(Predicate<Path> keyPredicate) {
        return this.theCache.prune(keyPredicate);
    }

    public CacheUsage usage() {
        return this.theCache.usage();
    }

    public CacheStats stats() {
        return this.theCache.stats();
    }

    private void checkParentBreaker(Path filePath) {
        try {
            this.circuitBreaker.addEstimateBytesAndMaybeBreak(0L, "filecache_entry");
        }
        catch (CircuitBreakingException ex) {
            this.theCache.remove((Object)filePath);
            throw new CircuitBreakingException("Unable to create file cache entries", ex.getBytesWanted(), ex.getByteLimit(), ex.getDurability());
        }
    }

    public void restoreFromDirectory(List<Path> fileCacheDataPaths) {
        fileCacheDataPaths.stream().filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(path -> path.resolve("RemoteLocalStore")).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).flatMap(dir -> {
            try {
                return Files.list(dir);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Unable to process file cache directory. Please clear the file cache for node startup.", e);
            }
        }).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(path -> {
            try {
                this.put(path.toAbsolutePath(), new RestoredCachedIndexInput(Files.size(path)));
                this.decRef(path.toAbsolutePath());
            }
            catch (IOException e) {
                throw new UncheckedIOException("Unable to retrieve cache file details. Please clear the file cache for node startup.", e);
            }
        });
    }

    public FileCacheStats fileCacheStats() {
        CacheStats stats = this.stats();
        CacheUsage usage = this.usage();
        return new FileCacheStats(System.currentTimeMillis(), usage.activeUsage(), this.capacity(), usage.usage(), stats.evictionWeight(), stats.hitCount(), stats.missCount());
    }

    private static class RestoredCachedIndexInput
    implements CachedIndexInput {
        private final long length;

        private RestoredCachedIndexInput(long length) {
            this.length = length;
        }

        @Override
        public IndexInput getIndexInput() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long length() {
            return this.length;
        }

        @Override
        public boolean isClosed() {
            return true;
        }

        @Override
        public void close() throws Exception {
        }
    }

    public static class SettingsProviderImpl
    implements SettingsProvider {
        @Override
        public List<? extends Setting<?>> getSettings() {
            return Collections.singletonList(DATA_TO_FILE_CACHE_SIZE_RATIO_SETTING);
        }
    }
}

