/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.seqno;

import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.action.ActionListener;
import io.skylite.core.action.ActionFilters;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.action.replication.ReplicationResponse;
import io.skylite.core.action.replication.ReplicationTask;
import io.skylite.core.action.support.ActiveShardCount;
import io.skylite.core.action.support.replication.ReplicationRequest;
import io.skylite.core.action.support.replication.TransportReplicationAction;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.common.inject.Inject;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.index.IndexNotFoundException;
import io.skylite.core.index.seqno.RetentionLeases;
import io.skylite.core.index.shard.BaseIndexShard;
import io.skylite.core.index.shard.IndexShardClosedException;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.node.NodeClosedException;
import io.skylite.core.settings.Settings;
import io.skylite.core.tasks.Task;
import io.skylite.core.tasks.TaskId;
import io.skylite.core.threadpool.ThreadPool;
import io.skylite.core.transport.TransportException;
import io.skylite.core.transport.TransportResponseHandler;
import io.skylite.core.transport.TransportService;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.store.AlreadyClosedException;

public class RetentionLeaseBackgroundSyncAction
extends TransportReplicationAction<Request, Request, ReplicationResponse> {
    public static final String ACTION_NAME = "indices:admin/seq_no/retention_lease_background_sync";
    private static final Logger LOGGER = LogManager.getLogger(RetentionLeaseBackgroundSyncAction.class);

    protected Logger getLogger() {
        return LOGGER;
    }

    @Inject
    public RetentionLeaseBackgroundSyncAction(Settings settings, TransportService transportService, ClusterService clusterService, TransportReplicationAction.IndexServiceProvider indexServiceProvider, ThreadPool threadPool, TransportReplicationAction.RemoteShardFailedAction remoteShardFailedAction, ActionFilters actionFilters) {
        super(settings, ACTION_NAME, transportService, clusterService, indexServiceProvider, threadPool, remoteShardFailedAction, actionFilters, Request::new, Request::new, "management");
    }

    @Override
    protected void doExecute(Task task, Request request, ActionListener<ReplicationResponse> listener) {
        assert (false) : "use RetentionLeaseBackgroundSyncAction#backgroundSync";
    }

    final void backgroundSync(final ShardId shardId, String primaryAllocationId, long primaryTerm, RetentionLeases retentionLeases) {
        ThreadContext threadContext = this.threadPool.getThreadContext();
        try (ThreadContext.StoredContext ignore = threadContext.stashContext();){
            threadContext.markAsSystemContext();
            Request request = new Request(shardId, retentionLeases);
            final ReplicationTask task = (ReplicationTask)this.taskManager.register("transport", "retention_lease_background_sync", request);
            this.transportService.sendChildRequest(this.clusterService.localNode(), this.transportPrimaryAction, new TransportReplicationAction.ConcreteShardRequest<Request>(request, primaryAllocationId, primaryTerm), (Task)task, this.transportOptions, new TransportResponseHandler<ReplicationResponse>(){

                @Override
                public ReplicationResponse read(StreamInput in) throws IOException {
                    return RetentionLeaseBackgroundSyncAction.this.newResponseInstance(in);
                }

                @Override
                public String executor() {
                    return "same";
                }

                @Override
                public void handleResponse(ReplicationResponse response) {
                    task.setPhase("finished");
                    RetentionLeaseBackgroundSyncAction.this.taskManager.unregister(task);
                }

                @Override
                public void handleException(TransportException e) {
                    task.setPhase("finished");
                    RetentionLeaseBackgroundSyncAction.this.taskManager.unregister(task);
                    if (SkyliteExceptionsHelper.unwrap(e, NodeClosedException.class) != null) {
                        return;
                    }
                    if (SkyliteExceptionsHelper.unwrap(e, IndexNotFoundException.class, AlreadyClosedException.class, IndexShardClosedException.class) != null) {
                        return;
                    }
                    RetentionLeaseBackgroundSyncAction.this.getLogger().warn((Message)new ParameterizedMessage("{} retention lease background sync failed", (Object)shardId), (Throwable)e);
                }
            });
        }
    }

    @Override
    protected void shardOperationOnPrimary(Request request, BaseIndexShard primary, ActionListener<TransportReplicationAction.PrimaryResult<Request, ReplicationResponse>> listener) {
        ActionListenerHelper.completeWith(listener, () -> {
            assert (request.waitForActiveShards().equals(ActiveShardCount.NONE)) : request.waitForActiveShards();
            Objects.requireNonNull(request);
            Objects.requireNonNull(primary);
            primary.persistRetentionLeases();
            return new TransportReplicationAction.PrimaryResult<Request, ReplicationResponse>(request, new ReplicationResponse());
        });
    }

    @Override
    protected void shardOperationOnReplica(Request request, BaseIndexShard replica, ActionListener<TransportReplicationAction.ReplicaResult> listener) {
        ActionListenerHelper.completeWith(listener, () -> {
            Objects.requireNonNull(request);
            Objects.requireNonNull(replica);
            replica.updateRetentionLeasesOnReplica(request.getRetentionLeases());
            replica.persistRetentionLeases();
            return new TransportReplicationAction.ReplicaResult();
        });
    }

    @Override
    protected ReplicationResponse newResponseInstance(StreamInput in) throws IOException {
        return new ReplicationResponse(in);
    }

    public static final class Request
    extends ReplicationRequest<Request> {
        private RetentionLeases retentionLeases;

        public RetentionLeases getRetentionLeases() {
            return this.retentionLeases;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.retentionLeases = new RetentionLeases(in);
        }

        public Request(ShardId shardId, RetentionLeases retentionLeases) {
            super(Objects.requireNonNull(shardId));
            this.retentionLeases = Objects.requireNonNull(retentionLeases);
            this.waitForActiveShards(ActiveShardCount.NONE);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(Objects.requireNonNull(out));
            this.retentionLeases.writeTo(out);
        }

        @Override
        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new ReplicationTask(id, type, action, "retention_lease_background_sync shardId=" + String.valueOf(this.shardId), parentTaskId, headers);
        }

        @Override
        public String toString() {
            return "RetentionLeaseBackgroundSyncAction.Request{retentionLeases=" + String.valueOf(this.retentionLeases) + ", shardId=" + String.valueOf(this.shardId) + ", timeout=" + String.valueOf(this.timeout) + ", index='" + this.index + "', waitForActiveShards=" + String.valueOf(this.waitForActiveShards) + "}";
        }
    }
}

