/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.shard;

import io.skylite.SkyliteException;
import io.skylite.common.Nullable;
import io.skylite.common.action.ActionListener;
import io.skylite.common.collect.Tuple;
import io.skylite.common.concurrent.GatedCloseable;
import io.skylite.common.lease.Releasable;
import io.skylite.common.metrics.MeanMetric;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.WriteStateException;
import io.skylite.core.action.admin.indices.flush.FlushRequest;
import io.skylite.core.action.replication.ReplicationResponse;
import io.skylite.core.action.support.replication.PendingReplicationActions;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.node.DiscoveryNode;
import io.skylite.core.cluster.node.DiscoveryNodes;
import io.skylite.core.cluster.routing.ShardRouting;
import io.skylite.core.cluster.routing.ShardRoutingState;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.index.cache.bitset.ShardBitsetFilterCache;
import io.skylite.core.index.engine.Engine;
import io.skylite.core.index.engine.EngineException;
import io.skylite.core.index.engine.EngineOperation;
import io.skylite.core.index.engine.EngineResult;
import io.skylite.core.index.engine.NRTReplicationEngine;
import io.skylite.core.index.engine.RefreshFailedEngineException;
import io.skylite.core.index.engine.SafeCommitInfo;
import io.skylite.core.index.fielddata.ShardFieldData;
import io.skylite.core.index.remote.RemoteStoreSettings;
import io.skylite.core.index.remote.RemoteStoreUtils;
import io.skylite.core.index.seqno.ReplicationCheckpoint;
import io.skylite.core.index.seqno.ReplicationTracker;
import io.skylite.core.index.seqno.RetentionLease;
import io.skylite.core.index.seqno.RetentionLeaseSyncer;
import io.skylite.core.index.seqno.RetentionLeases;
import io.skylite.core.index.seqno.SeqNoStats;
import io.skylite.core.index.shard.AbstractIndexShardComponent;
import io.skylite.core.index.shard.GlobalCheckpointListeners;
import io.skylite.core.index.shard.IllegalIndexShardStateException;
import io.skylite.core.index.shard.IndexEventListener;
import io.skylite.core.index.shard.IndexShardClosedException;
import io.skylite.core.index.shard.IndexShardNotRecoveringException;
import io.skylite.core.index.shard.IndexShardState;
import io.skylite.core.index.shard.RefreshListeners;
import io.skylite.core.index.shard.ReplicationGroup;
import io.skylite.core.index.shard.SearchOperationListener;
import io.skylite.core.index.shard.ShardInterface;
import io.skylite.core.index.shard.ShardPath;
import io.skylite.core.index.store.Store;
import io.skylite.core.index.store.StoreFileMetadata;
import io.skylite.core.index.store.remote.RemoteSegmentStoreDirectory;
import io.skylite.core.index.translog.TranslogLocation;
import io.skylite.core.index.translog.TranslogOperation;
import io.skylite.core.index.translog.TranslogSettings;
import io.skylite.core.index.translog.TranslogSnapshotIterator;
import io.skylite.core.indices.recovery.RecoverySettings;
import io.skylite.core.indices.recovery.RecoveryState;
import io.skylite.core.mapper.MapperService;
import io.skylite.core.search.stats.SearchStats;
import io.skylite.core.search.stats.ShardSearchStats;
import io.skylite.core.threadpool.ThreadPool;
import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.search.Sort;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.util.ThreadInterruptedException;

public abstract class BaseIndexShard
extends AbstractIndexShardComponent
implements ShardInterface {
    public static final int OPERATIONS_BLOCKED = -1;
    protected static final EnumSet<IndexShardState> readAllowedStates = EnumSet.of(IndexShardState.STARTED, IndexShardState.POST_RECOVERY);
    protected final ReplicationTracker replicationTracker;
    protected final AtomicReference<Engine> currentEngineReference = new AtomicReference();
    protected final Runnable globalCheckpointSyncer;
    protected final GlobalCheckpointListeners globalCheckpointListeners;
    protected final PendingReplicationActions pendingReplicationActions;
    protected final ThreadPool threadPool;
    protected final RetentionLeaseSyncer retentionLeaseSyncer;
    protected final SearchOperationListener searchOperationListener;
    protected final ShardSearchStats searchStats = new ShardSearchStats();
    protected final Object postRecoveryMutex = new Object();
    protected final RefreshListeners refreshListeners;
    protected final AtomicLong lastSearcherAccess = new AtomicLong();
    protected final AtomicReference<TranslogLocation> pendingRefreshLocation = new AtomicReference();
    protected final MeanMetric externalRefreshMetric = new MeanMetric();
    protected final Store store;
    protected final IndexEventListener indexEventListener;
    protected final ShardPath path;
    protected final MapperService mapperService;
    protected final Supplier<Sort> indexSortSupplier;
    protected final Store remoteStore;
    protected final ShardFieldData shardFieldData;
    protected final ShardBitsetFilterCache shardBitsetFilterCache;
    protected final RemoteStoreSettings remoteStoreSettings;
    protected final RecoverySettings recoverySettings;
    protected volatile ShardRouting shardRouting;
    protected volatile IndexShardState state;
    protected volatile long pendingPrimaryTerm;
    @Nullable
    protected volatile RecoveryState recoveryState;
    private final ShardMigrationState shardMigrationState;
    protected DiscoveryNodes discoveryNodes;
    public Function<String, Boolean> isShardOnRemoteEnabledNode = nodeId -> {
        DiscoveryNode node = this.discoveryNodes.get((String)nodeId);
        if (node != null) {
            this.logger.trace("Node {} has remote_enabled as {}", nodeId, (Object)node.isRemoteStoreNode());
            return node.isRemoteStoreNode();
        }
        return false;
    };

    public BaseIndexShard(ShardRouting shardRouting, IndexSettings indexSettings, ShardPath path, Store store, Supplier<Sort> indexSortSupplier, MapperService mapperService, IndexEventListener indexEventListener, ThreadPool threadPool, List<SearchOperationListener> searchOperationListener, Runnable globalCheckpointSyncer, RetentionLeaseSyncer retentionLeaseSyncer, @Nullable Store remoteStore, @Nullable RemoteStoreSettings remoteStoreSettings, RecoverySettings recoverySettings, boolean seedRemote, DiscoveryNodes discoveryNodes) {
        super(shardRouting.shardId(), indexSettings);
        long primaryTerm;
        assert (shardRouting.initializing());
        this.shardRouting = shardRouting;
        this.store = store;
        this.indexSortSupplier = indexSortSupplier;
        this.indexEventListener = indexEventListener;
        this.threadPool = threadPool;
        this.mapperService = mapperService;
        this.globalCheckpointSyncer = globalCheckpointSyncer;
        this.retentionLeaseSyncer = Objects.requireNonNull(retentionLeaseSyncer);
        ArrayList<SearchOperationListener> searchListenersList = new ArrayList<SearchOperationListener>(searchOperationListener);
        searchListenersList.add(this.searchStats);
        this.searchOperationListener = new SearchOperationListener.CompositeListener(searchListenersList, this.logger);
        this.shardFieldData = new ShardFieldData();
        this.shardBitsetFilterCache = new ShardBitsetFilterCache(this.shardId, indexSettings);
        this.state = IndexShardState.CREATED;
        this.path = path;
        String aId = shardRouting.allocationId().getId();
        this.pendingPrimaryTerm = primaryTerm = indexSettings.getIndexMetadata().primaryTerm(this.shardId.id());
        this.globalCheckpointListeners = new GlobalCheckpointListeners(this.shardId, threadPool.scheduler(), this.logger);
        this.pendingReplicationActions = new PendingReplicationActions(this.shardId, threadPool);
        this.replicationTracker = new ReplicationTracker(this.shardId, aId, indexSettings, primaryTerm, -2L, this.globalCheckpointListeners::globalCheckpointUpdated, threadPool::absoluteTimeInMillis, (retentionLeases, listener) -> retentionLeaseSyncer.sync(this.shardId, aId, this.getPendingPrimaryTerm(), (RetentionLeases)retentionLeases, (ActionListener<ReplicationResponse>)listener), this::getSafeCommitInfo, this.pendingReplicationActions, this.isShardOnRemoteEnabledNode);
        this.refreshListeners = this.buildRefreshListeners();
        this.remoteStore = remoteStore;
        this.remoteStoreSettings = remoteStoreSettings;
        this.recoverySettings = recoverySettings;
        this.shardMigrationState = BaseIndexShard.getShardMigrationState(indexSettings, seedRemote);
        this.discoveryNodes = discoveryNodes;
    }

    protected boolean assertPrimaryMode() {
        assert (this.shardRouting.primary() && this.replicationTracker.isPrimaryMode()) : "shard " + String.valueOf(this.shardRouting) + " is not a primary shard in primary mode";
        return true;
    }

    protected void verifyNotClosed() throws IllegalIndexShardStateException {
        this.verifyNotClosed(null);
    }

    protected void verifyNotClosed(Exception suppressed) throws IllegalIndexShardStateException {
        IndexShardState state = this.state;
        if (state == IndexShardState.CLOSED) {
            IndexShardClosedException exc = new IndexShardClosedException(this.shardId, "operation only allowed when not closed");
            if (suppressed != null) {
                exc.addSuppressed(suppressed);
            }
            throw exc;
        }
    }

    public abstract long getMaxSeqNoOfUpdatesOrDeletes();

    public long getLastKnownGlobalCheckpoint() {
        return this.replicationTracker.getGlobalCheckpoint();
    }

    public long getLastSyncedGlobalCheckpoint() {
        return this.getEngine().getLastSyncedGlobalCheckpoint();
    }

    public Map<String, Long> getInSyncGlobalCheckpoints() {
        assert (this.assertPrimaryMode());
        this.verifyNotClosed();
        return this.replicationTracker.getInSyncGlobalCheckpoints();
    }

    public void maybeSyncGlobalCheckpoint(String reason) {
        boolean asyncDurability;
        this.verifyNotClosed();
        assert (this.shardRouting.primary()) : "only call maybeSyncGlobalCheckpoint on primary shard";
        if (!this.replicationTracker.isPrimaryMode()) {
            return;
        }
        assert (this.assertPrimaryMode());
        SeqNoStats stats = this.getEngine().getSeqNoStats(this.replicationTracker.getGlobalCheckpoint());
        boolean bl = asyncDurability = this.indexSettings().getTranslogDurability() == TranslogSettings.Durability.ASYNC;
        if (stats.getMaxSeqNo() == stats.getGlobalCheckpoint() || asyncDurability) {
            boolean syncNeeded;
            Map<String, Long> globalCheckpoints = this.getInSyncGlobalCheckpoints();
            long globalCheckpoint = this.replicationTracker.getGlobalCheckpoint();
            boolean bl2 = syncNeeded = asyncDurability && (stats.getGlobalCheckpoint() < stats.getMaxSeqNo() || this.replicationTracker.pendingInSync()) || StreamSupport.stream(globalCheckpoints.values().spliterator(), false).anyMatch(v -> v < globalCheckpoint);
            if (syncNeeded && this.indexSettings.getIndexMetadata().getState() == IndexMetadata.State.OPEN) {
                this.logger.trace("syncing global checkpoint for [{}]", (Object)reason);
                this.globalCheckpointSyncer.run();
            }
        }
    }

    public abstract void updateLocalCheckpointForShard(String var1, long var2);

    public abstract void updateGlobalCheckpointForShard(String var1, long var2);

    public abstract long getLocalCheckpoint();

    public abstract ReplicationCheckpoint getLatestReplicationCheckpoint();

    public abstract void finalizeReplication(SegmentInfos var1) throws IOException;

    public abstract GatedCloseable<SegmentInfos> getSegmentInfosSnapshot();

    public abstract ReplicationGroup getReplicationGroup();

    public abstract PendingReplicationActions getPendingReplicationActions();

    public abstract Map<String, StoreFileMetadata> getSegmentMetadataMap() throws IOException;

    public abstract void acquirePrimaryOperationPermit(ActionListener<Releasable> var1, String var2, Object var3);

    public abstract void acquirePrimaryOperationPermit(ActionListener<Releasable> var1, String var2, Object var3, boolean var4);

    public abstract void acquireAllPrimaryOperationsPermits(ActionListener<Releasable> var1, TimeValue var2);

    public abstract void acquireReplicaOperationPermit(long var1, long var3, long var5, ActionListener<Releasable> var7, String var8, Object var9);

    public abstract void acquireAllReplicaOperationsPermits(long var1, long var3, long var5, ActionListener<Releasable> var7, TimeValue var8);

    public Engine getEngine() {
        Engine engine = this.getEngineOrNull();
        if (engine == null) {
            throw new AlreadyClosedException("engine is closed");
        }
        return engine;
    }

    public abstract boolean shouldProcessCheckpoint(ReplicationCheckpoint var1);

    public Engine getEngineOrNull() {
        return this.currentEngineReference.get();
    }

    public long getPendingPrimaryTerm() {
        return this.pendingPrimaryTerm;
    }

    protected SafeCommitInfo getSafeCommitInfo() {
        Engine engine = this.getEngineOrNull();
        return engine == null ? SafeCommitInfo.EMPTY : engine.getSafeCommitInfo();
    }

    public void addGlobalCheckpointListener(long waitingForGlobalCheckpoint, GlobalCheckpointListeners.GlobalCheckpointListener listener, TimeValue timeout) {
        this.globalCheckpointListeners.add(waitingForGlobalCheckpoint, listener, timeout);
    }

    public SeqNoStats seqNoStats() {
        return this.getEngine().getSeqNoStats(this.replicationTracker.getGlobalCheckpoint());
    }

    public TranslogSnapshotIterator newChangesSnapshot(String source, long fromSeqNo, long toSeqNo, boolean requiredFullRange, boolean accurateCount) throws IOException {
        return this.getEngine().newChangesSnapshot(source, fromSeqNo, toSeqNo, requiredFullRange, accurateCount);
    }

    public TranslogSnapshotIterator getHistoryOperations(String reason, long startingSeqNo, long endSeqNo, boolean accurateCount) throws IOException {
        return this.getEngine().newChangesSnapshot(reason, startingSeqNo, endSeqNo, true, accurateCount);
    }

    public TranslogSnapshotIterator getHistoryOperationsFromTranslog(long startingSeqNo, long endSeqNo) throws IOException {
        assert (!(this.indexSettings.isSegRepEnabledOrRemoteNode() || this.indexSettings.isRemoteStoreEnabled())) : "unsupported operation for segment replication enabled indices or remote store backed indices";
        return this.getEngine().translogManager().newChangesSnapshot(startingSeqNo, endSeqNo, true);
    }

    @Override
    public IndexShardState state() {
        return this.state;
    }

    public long getMaxSeenAutoIdTimestamp() {
        return this.getEngine().getMaxSeenAutoIdTimestamp();
    }

    @Override
    public ShardRouting routingEntry() {
        return this.shardRouting;
    }

    public RemoteStoreSettings getRemoteStoreSettings() {
        return this.remoteStoreSettings;
    }

    public SearchStats searchStats(String ... groups) {
        return this.searchStats.stats(groups);
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    public boolean isMigratingToRemote() {
        return this.shardMigrationState == ShardMigrationState.REMOTE_MIGRATING_UNSEEDED || this.shardMigrationState == ShardMigrationState.REMOTE_MIGRATING_SEEDED;
    }

    public boolean shouldSeedRemoteStore() {
        return this.shardMigrationState == ShardMigrationState.REMOTE_MIGRATING_UNSEEDED;
    }

    public boolean isRemoteSeeded() {
        return this.shardMigrationState == ShardMigrationState.REMOTE_MIGRATING_SEEDED;
    }

    public SearchOperationListener getSearchOperationListener() {
        return this.searchOperationListener;
    }

    public boolean isSystem() {
        return this.indexSettings.getIndexMetadata().isSystem();
    }

    public void failShard(String reason, @Nullable Exception e) {
        this.getEngine().failEngine(reason, e);
    }

    public Optional<NRTReplicationEngine> getReplicationEngine() {
        if (this.getEngine() instanceof NRTReplicationEngine) {
            return Optional.of((NRTReplicationEngine)this.getEngine());
        }
        return Optional.empty();
    }

    public boolean isSegmentReplicationAllowed() {
        if (!this.indexSettings.isSegRepEnabledOrRemoteNode()) {
            this.logger.trace("Attempting to perform segment replication when it is not enabled on the index");
            return false;
        }
        if (this.getReplicationTracker().isPrimaryMode()) {
            this.logger.trace("Shard is in primary mode and cannot perform segment replication as a replica.");
            return false;
        }
        if (this.routingEntry().primary()) {
            this.logger.trace("Shard routing is marked primary thus cannot perform segment replication as replica");
            return false;
        }
        if (!this.state().equals((Object)IndexShardState.STARTED) && !(this.state() == IndexShardState.POST_RECOVERY && this.shardRouting.state() == ShardRoutingState.INITIALIZING)) {
            this.logger.trace(() -> new ParameterizedMessage("Shard is not started or recovering {} {} and cannot perform segment replication as a replica", (Object)this.state(), (Object)this.shardRouting.state()));
            return false;
        }
        if (this.getReplicationEngine().isEmpty()) {
            this.logger.trace(() -> new ParameterizedMessage("Shard does not have the correct engine type to perform segment replication {}.", this.getEngine().getClass()));
            return false;
        }
        return true;
    }

    protected void markSearcherAccessed() {
        this.lastSearcherAccess.lazySet(this.threadPool.relativeTimeInMillis());
    }

    public boolean isReadAllowed() {
        return readAllowedStates.contains((Object)this.state);
    }

    public ReplicationTracker getReplicationTracker() {
        return this.replicationTracker;
    }

    public abstract boolean isRelocatedPrimary();

    public final void awaitShardSearchActive(Consumer<Boolean> listener) {
        this.markSearcherAccessed();
        TranslogLocation location = this.pendingRefreshLocation.get();
        if (location != null) {
            this.addRefreshListener(location, b -> {
                this.pendingRefreshLocation.compareAndSet(location, null);
                listener.accept(true);
            });
        } else {
            listener.accept(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRefreshListener(TranslogLocation location, Consumer<Boolean> listener) {
        boolean readAllowed;
        if (this.isReadAllowed()) {
            readAllowed = true;
        } else {
            Object object = this.postRecoveryMutex;
            synchronized (object) {
                readAllowed = this.isReadAllowed();
            }
        }
        if (readAllowed && !this.isSegmentReplicationAllowed()) {
            this.refreshListeners.addOrNotify(location, listener);
        } else {
            listener.accept(false);
        }
    }

    public Store store() {
        return this.store;
    }

    protected RefreshListeners buildRefreshListeners() {
        return new RefreshListeners(this.indexSettings::getMaxRefreshListeners, () -> this.refresh("too_many_listeners"), this.logger, this.threadPool.getThreadContext(), this.externalRefreshMetric);
    }

    public void refresh(String source) {
        this.verifyNotClosed();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("refresh with source [{}]", (Object)source);
        }
        this.getEngine().refresh(source);
    }

    public GatedCloseable<IndexCommit> acquireLastIndexCommit(boolean flushFirst) throws EngineException {
        IndexShardState state = this.state;
        if (state == IndexShardState.STARTED || state == IndexShardState.CLOSED) {
            return this.getEngine().acquireLastIndexCommit(flushFirst);
        }
        throw new IllegalIndexShardStateException(this.shardId, state, "snapshot is not allowed", new Object[0]);
    }

    public void waitForRemoteStoreSync() {
        this.waitForRemoteStoreSync(() -> {});
    }

    public void waitForRemoteStoreSync(Runnable onProgress) {
        assert (this.indexSettings.isAssignedOnRemoteNode());
        RemoteSegmentStoreDirectory directory = this.getRemoteDirectory();
        int segmentUploadeCount = 0;
        if (!this.shardRouting.primary()) {
            return;
        }
        long startNanos = System.nanoTime();
        while (System.nanoTime() - startNanos < this.getRecoverySettings().internalRemoteUploadTimeout().nanos()) {
            try {
                if (!this.isRemoteSegmentStoreInSync()) {
                    if (directory.getSegmentsUploadedToRemoteStore().size() > segmentUploadeCount) {
                        onProgress.run();
                        this.logger.debug("Uploaded segment count {}", (Object)directory.getSegmentsUploadedToRemoteStore().size());
                        segmentUploadeCount = directory.getSegmentsUploadedToRemoteStore().size();
                    }
                    try {
                        Thread.sleep(TimeValue.timeValueSeconds((long)30L).seconds());
                        continue;
                    }
                    catch (InterruptedException ie) {
                        throw new SkyliteException("Interrupted waiting for completion of [{}]", (Throwable)ie, new Object[0]);
                    }
                }
                break;
            }
            catch (AlreadyClosedException e) {
                return;
            }
        }
    }

    public void preRecovery() {
        IndexShardState currentState = this.state;
        if (currentState == IndexShardState.CLOSED) {
            throw new IndexShardNotRecoveringException(this.shardId, currentState);
        }
        assert (currentState == IndexShardState.RECOVERING) : "expected a recovering shard " + String.valueOf(this.shardId) + " but got " + String.valueOf((Object)currentState);
        this.indexEventListener.beforeIndexShardRecovery(this, this.indexSettings);
    }

    public abstract RetentionLease addRetentionLease(String var1, long var2, String var4, ActionListener<ReplicationResponse> var5);

    public abstract RetentionLease renewRetentionLease(String var1, long var2, String var4);

    public abstract void removeRetentionLease(String var1, ActionListener<ReplicationResponse> var2);

    public abstract void updateRetentionLeasesOnReplica(RetentionLeases var1);

    public Tuple<Boolean, RetentionLeases> getRetentionLeases(boolean expireLeases) {
        assert (!expireLeases || this.assertPrimaryMode());
        this.verifyNotClosed();
        return this.replicationTracker.getRetentionLeases(expireLeases);
    }

    public RetentionLeases getRetentionLeases() {
        return (RetentionLeases)this.getRetentionLeases(false).v2();
    }

    public RetentionLeases loadRetentionLeases() throws IOException {
        this.verifyNotClosed();
        return this.replicationTracker.loadRetentionLeases(this.path.getShardStatePath());
    }

    public void persistRetentionLeases() throws WriteStateException {
        this.verifyNotClosed();
        this.replicationTracker.persistRetentionLeases(this.path.getShardStatePath());
    }

    public ShardPath shardPath() {
        return this.path;
    }

    public void prepareForIndexRecovery() {
        if (this.state != IndexShardState.RECOVERING) {
            throw new IndexShardNotRecoveringException(this.shardId, this.state);
        }
        this.recoveryState.setStage(RecoveryState.Stage.INDEX);
        assert (this.currentEngineReference.get() == null);
    }

    public MapperService mapperService() {
        return this.mapperService;
    }

    public Sort getIndexSort() {
        return this.indexSortSupplier.get();
    }

    public Store remoteStore() {
        return this.remoteStore;
    }

    public ShardRouting shardRouting() {
        return this.shardRouting;
    }

    public IndexEventListener getIndexEventListener() {
        return this.indexEventListener;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isRemoteSegmentStoreInSync() {
        assert (this.indexSettings.isAssignedOnRemoteNode());
        try {
            RemoteSegmentStoreDirectory directory = this.getRemoteDirectory();
            if (directory.readLatestMetadataFile() == null) return false;
            Set<String> uploadFiles = directory.getSegmentsUploadedToRemoteStore().keySet();
            try (GatedCloseable<SegmentInfos> segmentInfosGatedCloseable = this.getSegmentInfosSnapshot();){
                Collection localSegmentInfosFiles = ((SegmentInfos)segmentInfosGatedCloseable.get()).files(true);
                HashSet localFiles = new HashSet(localSegmentInfosFiles);
                localFiles.removeAll(RemoteStoreUtils.REFRESH_EXCLUDE_FILES);
                if (uploadFiles.containsAll(localFiles)) {
                    boolean bl = true;
                    return bl;
                }
                this.logger.debug(() -> new ParameterizedMessage("RemoteSegmentStoreSyncStatus localSize={} remoteSize={}", (Object)localFiles.size(), (Object)uploadFiles.size()));
                return false;
            }
        }
        catch (AlreadyClosedException e) {
            throw e;
        }
        catch (Throwable e) {
            this.logger.error("Exception while reading latest metadata", e);
        }
        return false;
    }

    public void activateThrottling() {
        try {
            this.getEngine().activateThrottling();
        }
        catch (AlreadyClosedException alreadyClosedException) {
            // empty catch block
        }
    }

    public void deactivateThrottling() {
        try {
            this.getEngine().deactivateThrottling();
        }
        catch (AlreadyClosedException alreadyClosedException) {
            // empty catch block
        }
    }

    public ShardFieldData fieldData() {
        return this.shardFieldData;
    }

    public ShardBitsetFilterCache shardBitsetFilterCache() {
        return this.shardBitsetFilterCache;
    }

    public void onCheckpointPublished(ReplicationCheckpoint checkpoint) {
        this.replicationTracker.startReplicationLagTimers(checkpoint);
    }

    public boolean isRemoteTranslogEnabled() {
        return this.indexSettings() != null && this.indexSettings().isRemoteTranslogStoreEnabled();
    }

    public boolean isStartedPrimary() {
        return this.getReplicationTracker().isPrimaryMode() && this.state() == IndexShardState.STARTED;
    }

    public boolean enableUploadToRemoteTranslog() {
        return this.isStartedPrimary() || this.shouldSeedRemoteStore() && this.hasOneRemoteSegmentSyncHappened();
    }

    private boolean hasOneRemoteSegmentSyncHappened() {
        assert (this.indexSettings.isAssignedOnRemoteNode());
        RemoteSegmentStoreDirectory rd = this.getRemoteDirectory();
        AtomicBoolean segment_n_uploaded = new AtomicBoolean(false);
        rd.getSegmentsUploadedToRemoteStore().forEach((key, value) -> {
            if (key.startsWith("segments")) {
                segment_n_uploaded.set(true);
            }
        });
        return segment_n_uploaded.get();
    }

    public long getIndexBufferRAMBytesUsed() {
        Engine engine = this.getEngineOrNull();
        if (engine == null) {
            return 0L;
        }
        try {
            return engine.getIndexBufferRAMBytesUsed();
        }
        catch (AlreadyClosedException ex) {
            return 0L;
        }
    }

    public long getWritingBytes() {
        Engine engine = this.getEngineOrNull();
        if (engine == null) {
            return 0L;
        }
        return engine.getWritingBytes();
    }

    protected void handleRefreshException(Exception e) {
        if (!(e instanceof AlreadyClosedException)) {
            if (e instanceof RefreshFailedEngineException) {
                RefreshFailedEngineException rfee = (RefreshFailedEngineException)e;
                if (!(rfee.getCause() instanceof InterruptedException || rfee.getCause() instanceof ClosedByInterruptException || rfee.getCause() instanceof ThreadInterruptedException || this.state == IndexShardState.CLOSED)) {
                    this.logger.warn("Failed to perform engine refresh", (Throwable)e);
                }
            } else if (this.state != IndexShardState.CLOSED) {
                this.logger.warn("Failed to perform engine refresh", (Throwable)e);
            }
        }
    }

    public abstract long getOperationPrimaryTerm();

    public abstract boolean isPrimaryMode();

    public abstract Engine.Searcher acquireSearcher(String var1);

    public abstract EngineResult applyTranslogOperation(TranslogOperation var1, EngineOperation.Origin var2) throws IOException;

    public abstract void updateMaxUnsafeAutoIdTimestamp(long var1);

    protected RemoteSegmentStoreDirectory getRemoteDirectory() {
        assert (this.indexSettings.isAssignedOnRemoteNode());
        assert (this.remoteStore.directory() instanceof FilterDirectory) : "Store.directory is not an instance of FilterDirectory";
        FilterDirectory remoteStoreDirectory = (FilterDirectory)this.remoteStore.directory();
        FilterDirectory byteSizeCachingStoreDirectory = (FilterDirectory)remoteStoreDirectory.getDelegate();
        Directory remoteDirectory = byteSizeCachingStoreDirectory.getDelegate();
        return (RemoteSegmentStoreDirectory)remoteDirectory;
    }

    public abstract void trimOperationOfPreviousPrimaryTerms(long var1);

    public abstract TranslogSettings.Durability getTranslogDurability();

    public abstract int getActiveOperationsCount();

    public abstract void sync(TranslogLocation var1, Consumer<Exception> var2);

    public abstract void sync() throws IOException;

    public RecoverySettings getRecoverySettings() {
        return this.recoverySettings;
    }

    public abstract void flush(FlushRequest var1);

    public abstract void flushOnIdle(long var1);

    public abstract void afterWriteOperation();

    public void writeIndexingBuffer() {
        try {
            Engine engine = this.getEngine();
            engine.writeIndexingBuffer();
        }
        catch (Exception e) {
            this.handleRefreshException(e);
        }
    }

    public ShardRouting getShardRouting() {
        return this.shardRouting;
    }

    public void setState(IndexShardState state) {
        this.state = state;
    }

    public IndexShardState getState() {
        return this.state;
    }

    static ShardMigrationState getShardMigrationState(IndexSettings indexSettings, boolean shouldSeed) {
        if (indexSettings.isAssignedOnRemoteNode() && indexSettings.isRemoteStoreEnabled()) {
            return ShardMigrationState.REMOTE_NON_MIGRATING;
        }
        if (indexSettings.isAssignedOnRemoteNode()) {
            return shouldSeed ? ShardMigrationState.REMOTE_MIGRATING_UNSEEDED : ShardMigrationState.REMOTE_MIGRATING_SEEDED;
        }
        return ShardMigrationState.DOCREP_NON_MIGRATING;
    }

    static enum ShardMigrationState {
        REMOTE_NON_MIGRATING,
        REMOTE_MIGRATING_SEEDED,
        REMOTE_MIGRATING_UNSEEDED,
        DOCREP_NON_MIGRATING;

    }

    public static final class ShardFailure {
        public final ShardRouting routing;
        public final String reason;
        @Nullable
        public final Exception cause;

        public ShardFailure(ShardRouting routing, String reason, @Nullable Exception cause) {
            this.routing = routing;
            this.reason = reason;
            this.cause = cause;
        }
    }
}

