/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.shard;

import io.skylite.Version;
import io.skylite.core.ParseField;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.routing.OperationRouting;
import io.skylite.core.lucene.search.Queries;
import io.skylite.core.mapper.Uid;
import java.io.IOException;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.Predicate;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.StoredFields;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;

final class ShardSplittingQuery
extends Query {
    private final IndexMetadata indexMetadata;
    private final int shardId;
    private final BitSetProducer nestedParentBitSetProducer;

    ShardSplittingQuery(IndexMetadata indexMetadata, int shardId, boolean hasNested) {
        this.indexMetadata = indexMetadata;
        this.shardId = shardId;
        this.nestedParentBitSetProducer = hasNested ? ShardSplittingQuery.newParentDocBitSetProducer(indexMetadata.getCreationVersion()) : null;
    }

    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) {
        return new ConstantScoreWeight(this, boost){

            public String toString() {
                return "weight(delete docs query)";
            }

            public ScorerSupplier scorerSupplier(final LeafReaderContext context) throws IOException {
                final LeafReader leafReader = context.reader();
                final FixedBitSet bitSet = new FixedBitSet(leafReader.maxDoc());
                final Terms terms = leafReader.terms(ParseField.CommonMetaFields.ROUTING_FIELD.getPreferredName());
                final Predicate<BytesRef> includeInShard = ref -> {
                    int targetShardId = OperationRouting.generateShardId(ShardSplittingQuery.this.indexMetadata, Uid.decodeId(ref.bytes, ref.offset, ref.length), null);
                    return ShardSplittingQuery.this.shardId == targetShardId;
                };
                return new ScorerSupplier(){

                    public Scorer get(long leadCost) throws IOException {
                        if (terms == null) {
                            assert (!ShardSplittingQuery.this.indexMetadata.isRoutingPartitionedIndex());
                            ShardSplittingQuery.findSplitDocs(ParseField.CommonMetaFields.ID_FIELD.getPreferredName(), includeInShard, leafReader, arg_0 -> ((FixedBitSet)bitSet).set(arg_0));
                        } else {
                            boolean routingRequired;
                            BitSet parentBitSet;
                            if (ShardSplittingQuery.this.nestedParentBitSetProducer == null) {
                                parentBitSet = null;
                            } else {
                                parentBitSet = ShardSplittingQuery.this.nestedParentBitSetProducer.getBitSet(context);
                                if (parentBitSet == null) {
                                    return null;
                                }
                            }
                            if (ShardSplittingQuery.this.indexMetadata.isRoutingPartitionedIndex()) {
                                Visitor visitor = new Visitor(leafReader);
                                TwoPhaseIterator twoPhaseIterator = parentBitSet == null ? new RoutingPartitionedDocIdSetIterator(visitor) : new NestedRoutingPartitionedDocIdSetIterator(visitor, parentBitSet);
                                return new ConstantScoreScorer(this.score(), scoreMode, twoPhaseIterator);
                            }
                            Function<IntConsumer, IntConsumer> maybeWrapConsumer = consumer -> {
                                if (parentBitSet != null) {
                                    return docId -> {
                                        if (parentBitSet.get(docId)) {
                                            consumer.accept(docId);
                                        }
                                    };
                                }
                                return consumer;
                            };
                            ShardSplittingQuery.findSplitDocs(ParseField.CommonMetaFields.ROUTING_FIELD.getPreferredName(), ref -> {
                                int targetShardId = OperationRouting.generateShardId(ShardSplittingQuery.this.indexMetadata, null, ref.utf8ToString());
                                return ShardSplittingQuery.this.shardId == targetShardId;
                            }, leafReader, maybeWrapConsumer.apply(arg_0 -> ((FixedBitSet)bitSet).set(arg_0)));
                            boolean bl = routingRequired = ShardSplittingQuery.this.indexMetadata.mapping() == null ? false : ShardSplittingQuery.this.indexMetadata.mapping().routingRequired();
                            if (!routingRequired && terms.getDocCount() != leafReader.maxDoc()) {
                                FixedBitSet hasRoutingValue = new FixedBitSet(leafReader.maxDoc());
                                ShardSplittingQuery.findSplitDocs(ParseField.CommonMetaFields.ROUTING_FIELD.getPreferredName(), ref -> false, leafReader, maybeWrapConsumer.apply(arg_0 -> ((FixedBitSet)hasRoutingValue).set(arg_0)));
                                IntConsumer bitSetConsumer = maybeWrapConsumer.apply(arg_0 -> ((FixedBitSet)bitSet).set(arg_0));
                                ShardSplittingQuery.findSplitDocs(ParseField.CommonMetaFields.ID_FIELD.getPreferredName(), includeInShard, leafReader, docId -> {
                                    if (!hasRoutingValue.get(docId)) {
                                        bitSetConsumer.accept(docId);
                                    }
                                });
                            }
                            if (parentBitSet != null) {
                                ShardSplittingQuery.this.markChildDocs(parentBitSet, (BitSet)bitSet);
                            }
                        }
                        return new ConstantScoreScorer(this.score(), scoreMode, (DocIdSetIterator)new BitSetIterator((BitSet)bitSet, (long)bitSet.length()));
                    }

                    public long cost() {
                        return leafReader.maxDoc();
                    }
                };
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return false;
            }
        };
    }

    private void markChildDocs(BitSet parentDocs, BitSet matchingDocs) {
        for (int currentDeleted = 0; currentDeleted < matchingDocs.length() && (currentDeleted = matchingDocs.nextSetBit(currentDeleted)) != Integer.MAX_VALUE; ++currentDeleted) {
            int previousParent = parentDocs.prevSetBit(Math.max(0, currentDeleted - 1));
            for (int i = previousParent + 1; i < currentDeleted; ++i) {
                matchingDocs.set(i);
            }
        }
    }

    public String toString(String field) {
        return "shard_splitting_query";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ShardSplittingQuery that = (ShardSplittingQuery)((Object)o);
        if (this.shardId != that.shardId) {
            return false;
        }
        return this.indexMetadata.equals(that.indexMetadata);
    }

    public int hashCode() {
        int result = this.indexMetadata.hashCode();
        result = 31 * result + this.shardId;
        return this.classHash() ^ result;
    }

    private static void findSplitDocs(String idField, Predicate<BytesRef> includeInShard, LeafReader leafReader, IntConsumer consumer) throws IOException {
        BytesRef idTerm;
        Terms terms = leafReader.terms(idField);
        TermsEnum iterator = terms.iterator();
        PostingsEnum postingsEnum = null;
        while ((idTerm = iterator.next()) != null) {
            int doc;
            if (includeInShard.test(idTerm)) continue;
            postingsEnum = iterator.postings(postingsEnum);
            while ((doc = postingsEnum.nextDoc()) != Integer.MAX_VALUE) {
                consumer.accept(doc);
            }
        }
    }

    private static BitSetProducer newParentDocBitSetProducer(Version indexVersionCreated) {
        return context -> {
            Query query = Queries.newNonNestedFilter();
            IndexReaderContext topLevelContext = ReaderUtil.getTopLevelContext((IndexReaderContext)context);
            IndexSearcher searcher = new IndexSearcher(topLevelContext);
            searcher.setQueryCache(null);
            Weight weight = searcher.createWeight(searcher.rewrite(query), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
            Scorer s = weight.scorer(context);
            return s == null ? null : BitSet.of((DocIdSetIterator)s.iterator(), (int)context.reader().maxDoc());
        };
    }

    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf((Query)this);
    }

    private static final class NestedRoutingPartitionedDocIdSetIterator
    extends TwoPhaseIterator {
        private final Visitor visitor;
        private final BitSet parentDocs;
        private int nextParent = -1;
        private boolean nextParentMatches;

        NestedRoutingPartitionedDocIdSetIterator(Visitor visitor, BitSet parentDocs) {
            super(DocIdSetIterator.all((int)visitor.leafReader.maxDoc()));
            this.parentDocs = parentDocs;
            this.visitor = visitor;
        }

        public boolean matches() throws IOException {
            int doc = this.approximation.docID();
            if (doc > this.nextParent) {
                this.nextParent = this.parentDocs.nextSetBit(doc);
                this.nextParentMatches = this.visitor.matches(this.nextParent);
            }
            return this.nextParentMatches;
        }

        public float matchCost() {
            return 42.0f;
        }
    }

    private static final class RoutingPartitionedDocIdSetIterator
    extends TwoPhaseIterator {
        private final Visitor visitor;

        RoutingPartitionedDocIdSetIterator(Visitor visitor) {
            super(DocIdSetIterator.all((int)visitor.leafReader.maxDoc()));
            this.visitor = visitor;
        }

        public boolean matches() throws IOException {
            return this.visitor.matches(this.approximation.docID());
        }

        public float matchCost() {
            return 42.0f;
        }
    }

    private final class Visitor
    extends StoredFieldVisitor {
        final LeafReader leafReader;
        final StoredFields storedFields;
        private int leftToVisit = 2;
        private final BytesRef spare = new BytesRef();
        private String routing;
        private String id;

        Visitor(LeafReader leafReader) throws IOException {
            this.leafReader = leafReader;
            this.storedFields = leafReader.storedFields();
        }

        public void binaryField(FieldInfo fieldInfo, byte[] value) throws IOException {
            if (!fieldInfo.name.equals(ParseField.CommonMetaFields.ID_FIELD.getPreferredName())) {
                throw new IllegalStateException("Unexpected field: " + fieldInfo.name);
            }
            this.id = Uid.decodeId(value);
        }

        public void stringField(FieldInfo fieldInfo, String value) throws IOException {
            if (!fieldInfo.name.equals(ParseField.CommonMetaFields.ROUTING_FIELD.getPreferredName())) {
                throw new IllegalStateException("Unexpected field: " + fieldInfo.name);
            }
            this.routing = value;
        }

        public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
            if (fieldInfo.name.equals(ParseField.CommonMetaFields.ID_FIELD.getPreferredName()) || fieldInfo.name.equals(ParseField.CommonMetaFields.ROUTING_FIELD.getPreferredName())) {
                --this.leftToVisit;
                return StoredFieldVisitor.Status.YES;
            }
            return this.leftToVisit == 0 ? StoredFieldVisitor.Status.STOP : StoredFieldVisitor.Status.NO;
        }

        boolean matches(int doc) throws IOException {
            this.id = null;
            this.routing = null;
            this.leftToVisit = 2;
            this.storedFields.document(doc, (StoredFieldVisitor)this);
            assert (this.id != null) : "docID must not be null - we might have hit a nested document";
            int targetShardId = OperationRouting.generateShardId(ShardSplittingQuery.this.indexMetadata, this.id, this.routing);
            return targetShardId != ShardSplittingQuery.this.shardId;
        }
    }
}

