/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.shard;

import io.skylite.common.Nullable;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.lucene.index.SkyliteDirectoryReader;
import io.skylite.core.lucene.index.SkyliteLeafReader;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.LeafReader;

public final class ShardUtils {
    private ShardUtils() {
    }

    @Nullable
    public static ShardId extractShardId(LeafReader reader) {
        SkyliteLeafReader esReader = SkyliteLeafReader.getLuceniaLeafReader(reader);
        if (esReader != null) {
            assert (reader.getRefCount() > 0) : "OpenSearchLeafReader is already closed";
            return esReader.shardId();
        }
        return null;
    }

    @Nullable
    public static ShardId extractShardId(DirectoryReader reader) {
        SkyliteDirectoryReader esReader = SkyliteDirectoryReader.getOpenSearchDirectoryReader(reader);
        if (esReader != null) {
            return esReader.shardId();
        }
        throw new IllegalArgumentException("can't extract shard ID, can't unwrap OpenSearchDirectoryReader");
    }
}

