/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.snapshots.blobstore;

import io.skylite.SkyliteParseException;
import io.skylite.core.ParseField;
import io.skylite.core.index.remote.RemoteStoreEnums;
import io.skylite.core.index.remote.RemoteStorePathStrategy;
import io.skylite.core.index.snapshots.IndexShardSnapshotStatus;
import io.skylite.core.index.snapshots.blobstore.IndexShardSnapshot;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.message.ParameterizedMessage;

public class RemoteStoreShardShallowCopySnapshot
implements ToXContentFragment,
IndexShardSnapshot {
    private final String snapshot;
    private final String version;
    private final long indexVersion;
    private final long startTime;
    private final long time;
    private final int totalFileCount;
    private final long totalSize;
    private final long primaryTerm;
    private final long commitGeneration;
    private final String remoteStoreRepository;
    private final String repositoryBasePath;
    private final String indexUUID;
    private final List<String> fileNames;
    private final RemoteStoreEnums.PathType pathType;
    private final RemoteStoreEnums.PathHashAlgorithm pathHashAlgorithm;
    static final String DEFAULT_VERSION = "2";
    static final String NAME = "name";
    static final String VERSION = "version";
    static final String INDEX_VERSION = "index_version";
    static final String START_TIME = "start_time";
    static final String TIME = "time";
    static final String INDEX_UUID = "index_uuid";
    static final String REMOTE_STORE_REPOSITORY = "remote_store_repository";
    static final String REPOSITORY_BASE_PATH = "remote_store_repository_base_path";
    static final String FILE_NAMES = "file_names";
    static final String PRIMARY_TERM = "primary_term";
    static final String COMMIT_GENERATION = "commit_generation";
    static final String TOTAL_FILE_COUNT = "number_of_files";
    static final String TOTAL_SIZE = "total_size";
    static final String PATH_TYPE = "path_type";
    static final String PATH_HASH_ALGORITHM = "path_hash_algorithm";
    private static final ParseField PARSE_NAME = new ParseField("name", new String[0]);
    private static final ParseField PARSE_VERSION = new ParseField("version", new String[0]);
    private static final ParseField PARSE_PRIMARY_TERM = new ParseField("primary_term", new String[0]);
    private static final ParseField PARSE_COMMIT_GENERATION = new ParseField("commit_generation", new String[0]);
    private static final ParseField PARSE_INDEX_VERSION = new ParseField("index_version", "index-version");
    private static final ParseField PARSE_START_TIME = new ParseField("start_time", new String[0]);
    private static final ParseField PARSE_TIME = new ParseField("time", new String[0]);
    private static final ParseField PARSE_TOTAL_FILE_COUNT = new ParseField("number_of_files", new String[0]);
    private static final ParseField PARSE_TOTAL_SIZE = new ParseField("total_size", new String[0]);
    private static final ParseField PARSE_INDEX_UUID = new ParseField("index_uuid", new String[0]);
    private static final ParseField PARSE_REMOTE_STORE_REPOSITORY = new ParseField("remote_store_repository", new String[0]);
    private static final ParseField PARSE_REPOSITORY_BASE_PATH = new ParseField("remote_store_repository_base_path", new String[0]);
    private static final ParseField PARSE_FILE_NAMES = new ParseField("file_names", new String[0]);
    private static final ParseField PARSE_PATH_TYPE = new ParseField("path_type", new String[0]);
    private static final ParseField PARSE_PATH_HASH_ALGORITHM = new ParseField("path_hash_algorithm", new String[0]);

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(VERSION, this.version);
        builder.field(NAME, this.snapshot);
        builder.field(INDEX_VERSION, this.indexVersion);
        builder.field(START_TIME, this.startTime);
        builder.field(TIME, this.time);
        builder.field(TOTAL_FILE_COUNT, this.totalFileCount);
        builder.field(TOTAL_SIZE, this.totalSize);
        builder.field(INDEX_UUID, this.indexUUID);
        builder.field(REMOTE_STORE_REPOSITORY, this.remoteStoreRepository);
        builder.field(COMMIT_GENERATION, this.commitGeneration);
        builder.field(PRIMARY_TERM, this.primaryTerm);
        builder.field(REPOSITORY_BASE_PATH, this.repositoryBasePath);
        builder.startArray(FILE_NAMES);
        for (String fileName : this.fileNames) {
            builder.value(fileName);
        }
        builder.endArray();
        if (Objects.nonNull((Object)this.pathType)) {
            builder.field(PATH_TYPE, this.pathType.getCode());
        }
        if (Objects.nonNull((Object)this.pathHashAlgorithm)) {
            builder.field(PATH_HASH_ALGORITHM, this.pathHashAlgorithm.getCode());
        }
        return builder;
    }

    public RemoteStoreShardShallowCopySnapshot(String snapshot, long indexVersion, long primaryTerm, long commitGeneration, long startTime, long time, int totalFileCount, long totalSize, String indexUUID, String remoteStoreRepository, String repositoryBasePath, List<String> fileNames, RemoteStoreEnums.PathType pathType, RemoteStoreEnums.PathHashAlgorithm pathHashAlgorithm) {
        this(DEFAULT_VERSION, snapshot, indexVersion, primaryTerm, commitGeneration, startTime, time, totalFileCount, totalSize, indexUUID, remoteStoreRepository, repositoryBasePath, fileNames, pathType, pathHashAlgorithm);
    }

    RemoteStoreShardShallowCopySnapshot(String version, String snapshot, long indexVersion, long primaryTerm, long commitGeneration, long startTime, long time, int totalFileCount, long totalSize, String indexUUID, String remoteStoreRepository, String repositoryBasePath, List<String> fileNames, RemoteStoreEnums.PathType pathType, RemoteStoreEnums.PathHashAlgorithm pathHashAlgorithm) {
        this.verifyParameters(version, snapshot, indexVersion, primaryTerm, commitGeneration, indexUUID, remoteStoreRepository, repositoryBasePath, pathType, pathHashAlgorithm);
        this.version = version;
        this.snapshot = snapshot;
        this.indexVersion = indexVersion;
        this.primaryTerm = primaryTerm;
        this.commitGeneration = commitGeneration;
        this.startTime = startTime;
        this.time = time;
        this.totalFileCount = totalFileCount;
        this.totalSize = totalSize;
        this.indexUUID = indexUUID;
        this.remoteStoreRepository = remoteStoreRepository;
        this.repositoryBasePath = repositoryBasePath;
        this.fileNames = fileNames;
        this.pathType = pathType;
        this.pathHashAlgorithm = pathHashAlgorithm;
    }

    public static RemoteStoreShardShallowCopySnapshot fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String snapshot = null;
        String version = null;
        long indexVersion = -1L;
        long startTime = 0L;
        long time = 0L;
        int totalFileCount = 0;
        long totalSize = 0L;
        String indexUUID = null;
        String remoteStoreRepository = null;
        String repositoryBasePath = null;
        long primaryTerm = -1L;
        long commitGeneration = -1L;
        ArrayList<String> fileNames = new ArrayList<String>();
        RemoteStoreEnums.PathType pathType = null;
        RemoteStoreEnums.PathHashAlgorithm pathHashAlgorithm = null;
        if (parser.currentToken() == null) {
            parser.nextToken();
        }
        String currentFieldName = parser.currentName();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (PARSE_NAME.match(currentFieldName, parser.getDeprecationHandler())) {
                    snapshot = parser.text();
                    continue;
                }
                if (PARSE_VERSION.match(currentFieldName, parser.getDeprecationHandler())) {
                    version = parser.text();
                    continue;
                }
                if (PARSE_INDEX_VERSION.match(currentFieldName, parser.getDeprecationHandler())) {
                    indexVersion = parser.longValue();
                    continue;
                }
                if (PARSE_PRIMARY_TERM.match(currentFieldName, parser.getDeprecationHandler())) {
                    primaryTerm = parser.longValue();
                    continue;
                }
                if (PARSE_COMMIT_GENERATION.match(currentFieldName, parser.getDeprecationHandler())) {
                    commitGeneration = parser.longValue();
                    continue;
                }
                if (PARSE_START_TIME.match(currentFieldName, parser.getDeprecationHandler())) {
                    startTime = parser.longValue();
                    continue;
                }
                if (PARSE_TIME.match(currentFieldName, parser.getDeprecationHandler())) {
                    time = parser.longValue();
                    continue;
                }
                if (PARSE_TOTAL_FILE_COUNT.match(currentFieldName, parser.getDeprecationHandler())) {
                    totalFileCount = parser.intValue();
                    continue;
                }
                if (PARSE_TOTAL_SIZE.match(currentFieldName, parser.getDeprecationHandler())) {
                    totalSize = parser.longValue();
                    continue;
                }
                if (PARSE_INDEX_UUID.match(currentFieldName, parser.getDeprecationHandler())) {
                    indexUUID = parser.text();
                    continue;
                }
                if (PARSE_REMOTE_STORE_REPOSITORY.match(currentFieldName, parser.getDeprecationHandler())) {
                    remoteStoreRepository = parser.text();
                    continue;
                }
                if (PARSE_REPOSITORY_BASE_PATH.match(currentFieldName, parser.getDeprecationHandler())) {
                    repositoryBasePath = parser.text();
                    continue;
                }
                if (PARSE_PATH_TYPE.match(currentFieldName, parser.getDeprecationHandler())) {
                    pathType = RemoteStoreEnums.PathType.fromCode(parser.intValue());
                    continue;
                }
                if (PARSE_PATH_HASH_ALGORITHM.match(currentFieldName, parser.getDeprecationHandler())) {
                    pathHashAlgorithm = RemoteStoreEnums.PathHashAlgorithm.fromCode(parser.intValue());
                    continue;
                }
                throw new SkyliteParseException("unknown parameter [{}]", currentFieldName);
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if (PARSE_FILE_NAMES.match(currentFieldName, parser.getDeprecationHandler())) {
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        fileNames.add(parser.text());
                    }
                    continue;
                }
                parser.skipChildren();
                continue;
            }
            parser.skipChildren();
        }
        return new RemoteStoreShardShallowCopySnapshot(version, snapshot, indexVersion, primaryTerm, commitGeneration, startTime, time, totalFileCount, totalSize, indexUUID, remoteStoreRepository, repositoryBasePath, fileNames, pathType, pathHashAlgorithm);
    }

    public long getPrimaryTerm() {
        return this.primaryTerm;
    }

    public long getCommitGeneration() {
        return this.commitGeneration;
    }

    public String getIndexUUID() {
        return this.indexUUID;
    }

    public String getRemoteStoreRepository() {
        return this.remoteStoreRepository;
    }

    public String getRepositoryBasePath() {
        return this.repositoryBasePath;
    }

    public String snapshot() {
        return this.snapshot;
    }

    public long startTime() {
        return this.startTime;
    }

    public long time() {
        return this.time;
    }

    public int incrementalFileCount() {
        return 0;
    }

    public int totalFileCount() {
        return this.totalFileCount;
    }

    public long incrementalSize() {
        return 0L;
    }

    public long totalSize() {
        return this.totalSize;
    }

    private void verifyParameters(String version, String snapshot, long indexVersion, long primaryTerm, long commitGeneration, String indexUUID, String remoteStoreRepository, String repositoryBasePath, RemoteStoreEnums.PathType pathType, RemoteStoreEnums.PathHashAlgorithm pathHashAlgorithm) {
        this.throwExceptionIfInvalid(Objects.isNull(version), "Invalid Version Provided");
        this.throwExceptionIfInvalid(Objects.isNull(snapshot), "Invalid/Missing Snapshot Name");
        this.throwExceptionIfInvalid(indexVersion < 0L, "Invalid Index Version");
        this.throwExceptionIfInvalid(primaryTerm < 0L, "Invalid Primary Term");
        this.throwExceptionIfInvalid(commitGeneration < 0L, "Invalid Commit Generation");
        this.throwExceptionIfInvalid(Objects.isNull(indexUUID), "Invalid/Missing Index UUID");
        this.throwExceptionIfInvalid(Objects.isNull(remoteStoreRepository), "Invalid/Missing Remote Store Repository");
        this.throwExceptionIfInvalid(Objects.isNull(repositoryBasePath), "Invalid/Missing Repository Base Path");
        this.throwExceptionIfInvalid(!this.isValidRemotePathConfiguration(version, pathType, pathHashAlgorithm), new ParameterizedMessage("Invalid combination of pathType={} pathHashAlgorithm={} for version={}", new Object[]{pathType, pathHashAlgorithm, version}).getFormattedMessage());
    }

    private void throwExceptionIfInvalid(boolean isInvalid, String exceptionStr) {
        if (isInvalid) {
            throw new IllegalArgumentException(exceptionStr);
        }
    }

    private boolean isValidRemotePathConfiguration(String version, RemoteStoreEnums.PathType pathType, RemoteStoreEnums.PathHashAlgorithm pathHashAlgorithm) {
        switch (version) {
            case "1": {
                return Objects.isNull((Object)pathType) && Objects.isNull((Object)pathHashAlgorithm);
            }
            case "2": {
                return Objects.nonNull((Object)pathType) && RemoteStorePathStrategy.isCompatible(pathType, pathHashAlgorithm);
            }
        }
        return false;
    }

    public RemoteStoreShardShallowCopySnapshot asClone(String targetSnapshotName, long startTime, long time) {
        return new RemoteStoreShardShallowCopySnapshot(targetSnapshotName, this.indexVersion, this.primaryTerm, this.commitGeneration, startTime, time, this.totalFileCount, this.totalSize, this.indexUUID, this.remoteStoreRepository, this.repositoryBasePath, this.fileNames, this.pathType, this.pathHashAlgorithm);
    }

    @Override
    public IndexShardSnapshotStatus getIndexShardSnapshotStatus() {
        return IndexShardSnapshotStatus.newDone(this.startTime, this.time, this.incrementalFileCount(), this.totalFileCount, this.incrementalSize(), this.totalSize, null);
    }

    public RemoteStoreEnums.PathType getPathType() {
        return this.pathType;
    }

    public RemoteStoreEnums.PathHashAlgorithm getPathHashAlgorithm() {
        return this.pathHashAlgorithm;
    }

    public RemoteStorePathStrategy getRemoteStorePathStrategy() {
        if (Objects.nonNull((Object)this.pathType)) {
            return new RemoteStorePathStrategy(this.pathType, this.pathHashAlgorithm);
        }
        return new RemoteStorePathStrategy(RemoteStoreEnums.PathType.FIXED);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RemoteStoreShardShallowCopySnapshot that = (RemoteStoreShardShallowCopySnapshot)obj;
        return Objects.equals(this.snapshot, that.snapshot) && Objects.equals(this.version, that.version) && this.indexVersion == that.indexVersion && this.startTime == that.startTime && this.time == that.time && this.totalFileCount == that.totalFileCount && this.totalSize == that.totalSize && this.primaryTerm == that.primaryTerm && this.commitGeneration == that.commitGeneration && Objects.equals(this.remoteStoreRepository, that.remoteStoreRepository) && Objects.equals(this.repositoryBasePath, that.repositoryBasePath) && Objects.equals(this.indexUUID, that.indexUUID) && Objects.equals(this.fileNames, that.fileNames) && Objects.equals((Object)this.pathType, (Object)that.pathType) && Objects.equals((Object)this.pathHashAlgorithm, (Object)that.pathHashAlgorithm);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.snapshot, this.version, this.indexVersion, this.startTime, this.time, this.totalFileCount, this.totalSize, this.primaryTerm, this.commitGeneration, this.remoteStoreRepository, this.repositoryBasePath, this.indexUUID, this.fileNames, this.pathType, this.pathHashAlgorithm});
    }
}

