/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.store.remote.directory;

import io.skylite.common.blobstore.BlobContainer;
import io.skylite.common.blobstore.BlobPath;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.index.remote.filecache.FileCache;
import io.skylite.core.index.remote.utils.TransferManager;
import io.skylite.core.index.shard.ShardPath;
import io.skylite.core.index.snapshots.blobstore.BlobStoreIndexShardSnapshot;
import io.skylite.core.index.snapshots.blobstore.IndexShardSnapshot;
import io.skylite.core.index.store.remote.directory.RemoteSnapshotDirectory;
import io.skylite.core.plugins.IndexStorePlugin;
import io.skylite.core.repositories.RepositoriesService;
import io.skylite.core.repositories.Repository;
import io.skylite.core.repositories.blobstore.BlobStoreRepository;
import io.skylite.core.snapshots.SnapshotId;
import io.skylite.core.threadpool.ThreadPool;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public final class RemoteSnapshotDirectoryFactory
implements IndexStorePlugin.DirectoryFactory {
    private final Supplier<RepositoriesService> repositoriesService;
    private final ThreadPool threadPool;
    private final FileCache remoteStoreFileCache;

    public RemoteSnapshotDirectoryFactory(Supplier<RepositoriesService> repositoriesService, ThreadPool threadPool, FileCache remoteStoreFileCache) {
        this.repositoriesService = repositoriesService;
        this.threadPool = threadPool;
        this.remoteStoreFileCache = remoteStoreFileCache;
    }

    @Override
    public Directory newDirectory(IndexSettings indexSettings, ShardPath localShardPath) throws IOException {
        String repositoryName = IndexSettings.SEARCHABLE_SNAPSHOT_REPOSITORY.get(indexSettings.getSettings());
        Repository repository = this.repositoriesService.get().repository(repositoryName);
        assert (repository instanceof BlobStoreRepository) : "repository should be instance of BlobStoreRepository";
        BlobStoreRepository blobStoreRepository = (BlobStoreRepository)repository;
        try {
            return this.createRemoteSnapshotDirectoryFromSnapshot(indexSettings, localShardPath, blobStoreRepository).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }

    private Future<RemoteSnapshotDirectory> createRemoteSnapshotDirectoryFromSnapshot(IndexSettings indexSettings, ShardPath localShardPath, BlobStoreRepository blobStoreRepository) throws IOException {
        BlobPath blobPath = blobStoreRepository.basePath().add("indices").add(IndexSettings.SEARCHABLE_SNAPSHOT_INDEX_ID.get(indexSettings.getSettings())).add(Integer.toString(localShardPath.getShardId().getId()));
        SnapshotId snapshotId = new SnapshotId(IndexSettings.SEARCHABLE_SNAPSHOT_ID_NAME.get(indexSettings.getSettings()), IndexSettings.SEARCHABLE_SNAPSHOT_ID_UUID.get(indexSettings.getSettings()));
        Path localStorePath = localShardPath.getDataPath().resolve("RemoteLocalStore");
        FSDirectory localStoreDir = FSDirectory.open((Path)Files.createDirectories(localStorePath, new FileAttribute[0]));
        localStoreDir.syncMetaData();
        return this.threadPool.executor("snapshot").submit(() -> {
            BlobContainer blobContainer = blobStoreRepository.blobStore().blobContainer(blobPath);
            IndexShardSnapshot indexShardSnapshot = blobStoreRepository.loadShardSnapshot(blobContainer, snapshotId);
            assert (indexShardSnapshot instanceof BlobStoreIndexShardSnapshot) : "indexShardSnapshot should be an instance of BlobStoreIndexShardSnapshot";
            BlobStoreIndexShardSnapshot snapshot = (BlobStoreIndexShardSnapshot)indexShardSnapshot;
            TransferManager transferManager = new TransferManager(blobContainer, this.remoteStoreFileCache);
            return new RemoteSnapshotDirectory(snapshot, localStoreDir, transferManager);
        });
    }
}

