/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.store.remote.lockmanager;

import io.skylite.common.blobstore.BlobContainer;
import io.skylite.common.blobstore.BlobPath;
import io.skylite.core.index.remote.RemoteStoreEnums;
import io.skylite.core.index.remote.RemoteStorePathStrategy;
import io.skylite.core.index.store.remote.RemoteBufferedOutputDirectory;
import io.skylite.core.index.store.remote.lockmanager.RemoteStoreLockManager;
import io.skylite.core.index.store.remote.lockmanager.RemoteStoreMetadataLockManager;
import io.skylite.core.repositories.RepositoriesService;
import io.skylite.core.repositories.Repository;
import io.skylite.core.repositories.RepositoryMissingException;
import io.skylite.core.repositories.blobstore.BlobStoreRepository;
import java.util.function.Supplier;

public class RemoteStoreLockManagerFactory {
    private final Supplier<RepositoriesService> repositoriesService;

    public RemoteStoreLockManagerFactory(Supplier<RepositoriesService> repositoriesService) {
        this.repositoriesService = repositoriesService;
    }

    public RemoteStoreLockManager newLockManager(String repositoryName, String indexUUID, String shardId, RemoteStorePathStrategy pathStrategy) {
        return RemoteStoreLockManagerFactory.newLockManager(this.repositoriesService.get(), repositoryName, indexUUID, shardId, pathStrategy);
    }

    public static RemoteStoreMetadataLockManager newLockManager(RepositoriesService repositoriesService, String repositoryName, String indexUUID, String shardId, RemoteStorePathStrategy pathStrategy) {
        RemoteStoreMetadataLockManager remoteStoreMetadataLockManager;
        block9: {
            Repository repository = repositoriesService.repository(repositoryName);
            try {
                assert (repository instanceof BlobStoreRepository) : "repository should be instance of BlobStoreRepository";
                BlobPath repositoryBasePath = ((BlobStoreRepository)repository).basePath();
                RemoteStorePathStrategy.PathInput lockFilesPathInput = RemoteStorePathStrategy.PathInput.builder().basePath(repositoryBasePath).indexUUID(indexUUID).shardId(shardId).dataCategory(RemoteStoreEnums.DataCategory.SEGMENTS).dataType(RemoteStoreEnums.DataType.LOCK_FILES).build();
                BlobPath lockDirectoryPath = pathStrategy.generatePath(lockFilesPathInput);
                BlobContainer lockDirectoryBlobContainer = ((BlobStoreRepository)repository).blobStore().blobContainer(lockDirectoryPath);
                remoteStoreMetadataLockManager = new RemoteStoreMetadataLockManager(new RemoteBufferedOutputDirectory(lockDirectoryBlobContainer));
                if (repository == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (repository != null) {
                        try {
                            repository.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RepositoryMissingException e) {
                    throw new IllegalArgumentException("Repository should be present to acquire/release lock", e);
                }
            }
            repository.close();
        }
        return remoteStoreMetadataLockManager;
    }

    public Supplier<RepositoriesService> getRepositoriesService() {
        return this.repositoriesService;
    }
}

