/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.storedfieldloader;

import io.skylite.core.ParseField;
import io.skylite.core.mapper.Uid;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.StoredFieldVisitor;

public final class IdOnlyStoredFieldLoader
extends StoredFieldVisitor {
    private String id = null;
    private boolean visited = false;

    public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) {
        if (this.visited) {
            return StoredFieldVisitor.Status.STOP;
        }
        if (ParseField.CommonMetaFields.ID_FIELD.getPreferredName().equals(fieldInfo.name)) {
            this.visited = true;
            return StoredFieldVisitor.Status.YES;
        }
        return StoredFieldVisitor.Status.NO;
    }

    public void binaryField(FieldInfo fieldInfo, byte[] value) {
        assert (ParseField.CommonMetaFields.ID_FIELD.getPreferredName().equals(fieldInfo.name)) : fieldInfo;
        if (ParseField.CommonMetaFields.ID_FIELD.getPreferredName().equals(fieldInfo.name)) {
            this.id = Uid.decodeId(value);
        }
    }

    public String getId() {
        return this.id;
    }

    public void reset() {
        this.id = null;
        this.visited = false;
    }
}

