/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.storedfieldloader;

import io.skylite.core.ParseField;
import io.skylite.core.mapper.Uid;
import java.util.List;
import java.util.function.Function;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.util.BytesRef;

public final class SingleStoredFieldLoader
extends StoredFieldVisitor {
    private final String fieldName;
    private final Function<Object, Object> fieldValueForDisplayProvider;
    private final List<Object> destination;

    public SingleStoredFieldLoader(String fieldName, Function<Object, Object> fieldValueForDisplayProvider, List<Object> destination) {
        this.fieldName = fieldName;
        this.fieldValueForDisplayProvider = fieldValueForDisplayProvider;
        this.destination = destination;
    }

    public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) {
        if (fieldInfo.name.equals(this.fieldName)) {
            return StoredFieldVisitor.Status.YES;
        }
        return StoredFieldVisitor.Status.NO;
    }

    private void addValue(Object value) {
        this.destination.add(this.fieldValueForDisplayProvider.apply(value));
    }

    public void binaryField(FieldInfo fieldInfo, byte[] value) {
        if (ParseField.CommonMetaFields.ID_FIELD.getPreferredName().equals(fieldInfo.name)) {
            this.addValue(Uid.decodeId(value));
        } else {
            this.addValue(new BytesRef(value));
        }
    }

    public void stringField(FieldInfo fieldInfo, String value) {
        this.addValue(value);
    }

    public void intField(FieldInfo fieldInfo, int value) {
        this.addValue(value);
    }

    public void longField(FieldInfo fieldInfo, long value) {
        this.addValue(value);
    }

    public void floatField(FieldInfo fieldInfo, float value) {
        this.addValue(Float.valueOf(value));
    }

    public void doubleField(FieldInfo fieldInfo, double value) {
        this.addValue(value);
    }
}

